/*
 * Decompiled with CFR 0.152.
 */
package chaoticnpc;

import necesse.engine.localization.message.GameMessage;
import necesse.engine.localization.message.StaticMessage;
import necesse.engine.registries.LogicGateRegistry;
import necesse.engine.registries.ObjectRegistry;
import necesse.engine.registries.TileRegistry;
import necesse.inventory.InventoryItem;

public class LangUtils {
    private final GameMessage localizationNotFound = new StaticMessage("N/A");

    public GameMessage getItemLang(InventoryItem inventoryItem) {
        GameMessage message = inventoryItem.item.getNewLocalization();
        if (this.isLocalizationFound(message)) {
            return message;
        }
        String itemStringID = inventoryItem.item.getStringID();
        message = ObjectRegistry.getObject((String)itemStringID).getObjectItem().getNewLocalization();
        if (this.isLocalizationFound(message)) {
            return message;
        }
        int gateID = LogicGateRegistry.getLogicGateID((String)itemStringID);
        message = LogicGateRegistry.getLogicGate((int)gateID).getNewLocalization();
        if (this.isLocalizationFound(message)) {
            return message;
        }
        message = TileRegistry.getTile((String)itemStringID).getTileItem().getNewLocalization();
        if (this.isLocalizationFound(message)) {
            return message;
        }
        return this.localizationNotFound;
    }

    public boolean isLocalizationFound(GameMessage message) {
        return !message.isSame(this.localizationNotFound);
    }
}

