/*
 * Decompiled with CFR 0.152.
 */
package engcake.excavator.patches;

import necesse.engine.modLoader.annotations.ModMethodPatch;
import necesse.engine.network.server.ServerClient;
import necesse.entity.DamagedObjectEntity;
import necesse.entity.ObjectDamageResult;
import necesse.entity.mobs.Attacker;
import necesse.level.gameObject.GameObject;
import necesse.level.maps.Level;
import necesse.level.maps.LevelObject;
import net.bytebuddy.asm.Advice;

@ModMethodPatch(target=DamagedObjectEntity.class, name="doObjectDamage", arguments={int.class, int.class, float.class, Attacker.class, ServerClient.class, boolean.class, int.class, int.class})
public class DoDamagePatch {
    @Advice.OnMethodExit
    static void onExit(@Advice.This DamagedObjectEntity self, @Advice.Argument(value=0) int objectLayerID, @Advice.Argument(value=1) int damage, @Advice.Argument(value=2) float toolTier, @Advice.Argument(value=3) Attacker attacker, @Advice.Argument(value=4) ServerClient client, @Advice.Argument(value=5) boolean showEffects, @Advice.Argument(value=6) int mouseX, @Advice.Argument(value=7) int mouseY, @Advice.Return ObjectDamageResult result) {
        if (DoDamagePatch.shouldSkipProcessing(client, result)) {
            return;
        }
        Level level = client.getLevel();
        int tileX = self.tileX;
        int tileY = self.tileY;
        if (DoDamagePatch.isOre(result.levelObject.object)) {
            DoDamagePatch.checkAdjacentObjects(level, objectLayerID, tileX, tileY, toolTier, attacker, client, showEffects, mouseX, mouseY);
        }
    }

    public static boolean shouldSkipProcessing(ServerClient client, ObjectDamageResult result) {
        return client == null || result == null || !result.destroyed;
    }

    public static boolean isOre(GameObject gameObject) {
        return gameObject.isOre;
    }

    public static void checkAdjacentObjects(Level level, int objectLayerID, int tileX, int tileY, float toolTier, Attacker attacker, ServerClient client, boolean showEffects, int mouseX, int mouseY) {
        LevelObject[] adjacentObjects;
        for (LevelObject levelObject : adjacentObjects = level.getAdjacentLevelObjects(tileX, tileY)) {
            if (!DoDamagePatch.isAdjacentOre(levelObject, tileX, tileY)) continue;
            DoDamagePatch.damageAdjacentOre(level, objectLayerID, levelObject, toolTier, attacker, client, showEffects, mouseX, mouseY);
        }
    }

    public static boolean isAdjacentOre(LevelObject levelObject, int tileX, int tileY) {
        return DoDamagePatch.isOre(levelObject.object) && (levelObject.tileX == tileX || levelObject.tileY == tileY);
    }

    public static void damageAdjacentOre(Level level, int objectLayerID, LevelObject levelObject, float toolTier, Attacker attacker, ServerClient client, boolean showEffects, int mouseX, int mouseY) {
        level.entityManager.doObjectDamage(objectLayerID, levelObject.tileX, levelObject.tileY, levelObject.object.objectHealth, toolTier, attacker, client, showEffects, mouseX, mouseY);
    }
}

