/*
 * Decompiled with CFR 0.152.
 */
package aphorea.projectiles.toolitem;

import aphorea.registry.AphBuffs;
import aphorea.utils.AphColors;
import java.awt.Color;
import java.util.List;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.network.server.ServerClient;
import necesse.engine.util.GameRandom;
import necesse.entity.Entity;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.itemAttacker.ItemAttackerMob;
import necesse.entity.projectile.Projectile;
import necesse.entity.trails.Trail;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.texture.TextureDrawOptions;
import necesse.gfx.drawOptions.texture.TextureDrawOptionsEnd;
import necesse.gfx.drawables.EntityDrawable;
import necesse.gfx.drawables.LevelSortedDrawable;
import necesse.gfx.drawables.OrderableDrawables;
import necesse.level.maps.Level;
import necesse.level.maps.LevelObjectHit;
import necesse.level.maps.light.GameLight;

public class UnstableGelProjectile
extends Projectile {
    int generation;
    int seed;

    public UnstableGelProjectile() {
    }

    public UnstableGelProjectile(Level level, Mob owner, float x, float y, float targetX, float targetY, float speed, int distance, GameDamage damage, int knockback, int generation, int seed) {
        this.generation = generation;
        this.seed = seed;
        this.setLevel(level);
        this.setOwner(owner);
        this.x = x;
        this.y = y;
        this.setTarget(targetX, targetY);
        this.speed = speed;
        this.distance = distance;
        this.setDamage(damage);
        this.knockback = knockback;
    }

    public void init() {
        super.init();
        this.givesLight = false;
        this.height = 20.0f;
        this.trailOffset = -14.0f;
        this.setWidth(20.0f, true);
        this.piercing = 10;
        this.bouncing = 3;
    }

    public Color getParticleColor() {
        return AphColors.unstableGel;
    }

    public Trail getTrail() {
        return new Trail((Projectile)this, this.getLevel(), AphColors.unstableGel, 26.0f, 500, this.getHeight());
    }

    public void addDrawables(List<LevelSortedDrawable> list, OrderableDrawables tileList, OrderableDrawables topList, OrderableDrawables overlayList, Level level, TickManager tickManager, GameCamera camera, PlayerMob perspective) {
        if (this.removed()) {
            return;
        }
        GameLight light = level.getLightLevel((Entity)this);
        int drawX = camera.getDrawX(this.x) - this.texture.getWidth() / 2;
        int drawY = camera.getDrawY(this.y);
        TextureDrawOptionsEnd options = this.texture.initDraw().light(light).rotate(this.getAngle(), this.texture.getWidth() / 2, 2).pos(drawX, drawY - (int)this.getHeight());
        list.add((LevelSortedDrawable)new EntityDrawable((Entity)this, (TextureDrawOptions)options){
            final /* synthetic */ TextureDrawOptions val$options;
            {
                this.val$options = textureDrawOptions;
                super(arg0);
            }

            public void draw(TickManager tickManager) {
                this.val$options.draw();
            }
        });
        this.addShadowDrawables(tileList, drawX, drawY, light, this.getAngle(), this.texture.getWidth() / 2, 2);
    }

    public void onHit(Mob mob, LevelObjectHit object, float x, float y, boolean fromPacket, ServerClient packetSubmitter) {
        Mob owner;
        super.onHit(mob, object, x, y, fromPacket, packetSubmitter);
        if (mob == null && object != null && this.bounced < this.getTotalBouncing() && this.canBounce && this.generation < 2 && (owner = this.getOwner()) instanceof ItemAttackerMob) {
            Projectile projectile = this.getProjectile(owner);
            ((ItemAttackerMob)owner).addAndSendAttackerProjectile(projectile);
        }
    }

    public void doHitLogic(Mob mob, LevelObjectHit object, float x, float y) {
        super.doHitLogic(mob, object, x, y);
        if (mob != null) {
            mob.addBuff(new ActiveBuff(AphBuffs.STICKY, mob, 2000, (Attacker)this), true);
        }
    }

    private Projectile getProjectile(Mob owner) {
        ++this.generation;
        UnstableGelProjectile projectile = new UnstableGelProjectile(this.getLevel(), owner, this.x, this.y, owner.x, owner.y, this.speed, this.distance - (int)this.traveledDistance, this.getDamage(), this.knockback, this.generation, this.seed);
        projectile.resetUniqueID(new GameRandom((long)this.seed));
        projectile.moveDist(40.0);
        return projectile;
    }
}

