/*
 * Decompiled with CFR 0.152.
 */
package aphorea.projectiles.toolitem;

import aphorea.utils.AphColors;
import java.awt.Color;
import java.util.List;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.network.server.ServerClient;
import necesse.entity.Entity;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.projectile.Projectile;
import necesse.entity.trails.Trail;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.texture.TextureDrawOptions;
import necesse.gfx.drawOptions.texture.TextureDrawOptionsEnd;
import necesse.gfx.drawables.EntityDrawable;
import necesse.gfx.drawables.LevelSortedDrawable;
import necesse.gfx.drawables.OrderableDrawables;
import necesse.level.maps.Level;
import necesse.level.maps.LevelObjectHit;
import necesse.level.maps.light.GameLight;

public class SpinelArrowProjectile
extends Projectile {
    public static Color[] colors = new Color[]{AphColors.spinel_light, AphColors.spinel, AphColors.spinel_dark};
    public static int[] thickness = new int[]{14, 16, 18};

    public SpinelArrowProjectile() {
    }

    public SpinelArrowProjectile(Level level, Mob owner, float x, float y, float targetX, float targetY, float speed, int distance, GameDamage damage, int knockback) {
        this.setLevel(level);
        this.setOwner(owner);
        this.x = x;
        this.y = y;
        this.setTarget(targetX, targetY);
        this.speed = speed;
        this.distance = distance;
        this.setDamage(damage);
        this.knockback = knockback;
    }

    public void init() {
        super.init();
        this.givesLight = false;
        this.height = 18.0f;
        this.trailOffset = -14.0f;
        this.setWidth(10.0f, true);
        this.piercing = 2;
        this.bouncing = 0;
    }

    public Color getParticleColor() {
        return this.amountHit == 0 ? null : (this.amountHit > 2 ? colors[2] : colors[this.amountHit]);
    }

    public Trail getTrail() {
        return new Trail((Projectile)this, this.getLevel(), this.amountHit > 2 ? colors[2] : colors[this.amountHit], this.amountHit > 2 ? (float)thickness[2] : (float)thickness[this.amountHit], 500, this.getHeight() - 2.0f);
    }

    public void addDrawables(List<LevelSortedDrawable> list, OrderableDrawables tileList, OrderableDrawables topList, OrderableDrawables overlayList, Level level, TickManager tickManager, GameCamera camera, PlayerMob perspective) {
        if (this.removed()) {
            return;
        }
        GameLight light = level.getLightLevel((Entity)this);
        int drawX = camera.getDrawX(this.x) - this.texture.getWidth() / 2;
        int drawY = camera.getDrawY(this.y);
        TextureDrawOptionsEnd options = this.texture.initDraw().light(light).rotate(this.getAngle(), this.texture.getWidth() / 2, 2).pos(drawX, drawY - (int)this.getHeight());
        list.add((LevelSortedDrawable)new EntityDrawable((Entity)this, (TextureDrawOptions)options){
            final /* synthetic */ TextureDrawOptions val$options;
            {
                this.val$options = textureDrawOptions;
                super(arg0);
            }

            public void draw(TickManager tickManager) {
                this.val$options.draw();
            }
        });
        this.addShadowDrawables(tileList, drawX, drawY, light, this.getAngle(), this.texture.getWidth() / 2, 2);
    }

    public float tickMovement(float delta) {
        float moveY;
        if (this.removed()) {
            return 0.0f;
        }
        float speed = this.speed * (0.5f + 0.5f * (float)this.amountHit);
        float moveX = this.getMoveDist(this.dx * speed, delta);
        double totalDist = Math.sqrt(moveX * moveX + (moveY = this.getMoveDist(this.dy * speed, delta)) * moveY);
        if (Double.isNaN(totalDist) || Double.isInfinite(totalDist)) {
            totalDist = 0.0;
        }
        this.moveDist(totalDist);
        if (this.removeIfOutOfBounds && !this.getLevel().regionManager.isTileLoaded(this.getTileX(), this.getTileY())) {
            this.remove();
        }
        return (float)totalDist;
    }

    public void applyDamage(Mob mob, float x, float y) {
        float damageMod = 1.0f + 0.25f * (float)this.amountHit;
        mob.isServerHit(this.getDamage().modDamage(damageMod), mob.x - x * -this.dx * 50.0f, mob.y - y * -this.dy * 50.0f, (float)this.knockback, (Attacker)this);
    }

    public void onHit(Mob mob, LevelObjectHit object, float x, float y, boolean fromPacket, ServerClient packetSubmitter) {
        super.onHit(mob, object, x, y, fromPacket, packetSubmitter);
        this.replaceTrail();
    }
}

