/*
 * Decompiled with CFR 0.152.
 */
package aphorea.projectiles.toolitem;

import aphorea.utils.AphColors;
import java.awt.Color;
import java.util.List;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.entity.Entity;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.projectile.Projectile;
import necesse.entity.trails.Trail;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.texture.TextureDrawOptions;
import necesse.gfx.drawOptions.texture.TextureDrawOptionsEnd;
import necesse.gfx.drawables.EntityDrawable;
import necesse.gfx.drawables.LevelSortedDrawable;
import necesse.gfx.drawables.OrderableDrawables;
import necesse.gfx.gameTexture.GameTexture;
import necesse.level.maps.Level;
import necesse.level.maps.light.GameLight;

public abstract class AircutProjectile
extends Projectile {
    abstract Color getColor();

    abstract GameTexture getTexture();

    public AircutProjectile() {
    }

    public AircutProjectile(Level level, Mob owner, float x, float y, float targetX, float targetY, float speed, int distance, GameDamage damage, int knockback) {
        this.setLevel(level);
        this.setOwner(owner);
        this.x = x;
        this.y = y;
        this.setTarget(targetX, targetY);
        this.speed = speed;
        this.distance = distance;
        this.setDamage(damage);
        this.knockback = knockback;
    }

    public void init() {
        super.init();
        this.givesLight = false;
        this.height = 18.0f;
        this.trailOffset = -10.0f;
        this.setWidth(36.0f, true);
        this.piercing = 10;
        this.bouncing = 0;
    }

    public Color getParticleColor() {
        return this.getColor();
    }

    public Trail getTrail() {
        return new Trail((Projectile)this, this.getLevel(), this.getColor(), 32.0f, 50, this.getHeight());
    }

    public void addDrawables(List<LevelSortedDrawable> list, OrderableDrawables tileList, OrderableDrawables topList, OrderableDrawables overlayList, Level level, TickManager tickManager, GameCamera camera, PlayerMob perspective) {
        if (this.removed()) {
            return;
        }
        GameTexture texture = this.getTexture();
        GameLight light = level.getLightLevel((Entity)this);
        int drawX = camera.getDrawX(this.x) - texture.getWidth() / 2;
        int drawY = camera.getDrawY(this.y);
        TextureDrawOptionsEnd options = texture.initDraw().light(light).rotate(this.getAngle(), texture.getWidth() / 2, 2).pos(drawX, drawY - (int)this.getHeight());
        list.add((LevelSortedDrawable)new EntityDrawable((Entity)this, (TextureDrawOptions)options){
            final /* synthetic */ TextureDrawOptions val$options;
            {
                this.val$options = textureDrawOptions;
                super(arg0);
            }

            public void draw(TickManager tickManager) {
                this.val$options.draw();
            }
        });
    }

    public static class CrimsonAircutProjectile
    extends AircutProjectile {
        public static GameTexture texture;

        @Override
        Color getColor() {
            return AphColors.crimson_kora;
        }

        @Override
        GameTexture getTexture() {
            return texture;
        }

        public CrimsonAircutProjectile(Level level, Mob owner, float x, float y, float targetX, float targetY, float speed, int distance, GameDamage damage, int knockback) {
            super(level, owner, x, y, targetX, targetY, speed, distance, damage, knockback);
        }

        public CrimsonAircutProjectile() {
        }

        @Override
        public void init() {
            super.init();
            this.setWidth(56.0f, true);
            this.piercing = 20;
            this.givesLight = true;
        }
    }

    public static class DemonicAircutProjectile
    extends AircutProjectile {
        public static GameTexture texture;

        @Override
        Color getColor() {
            return AphColors.demonic;
        }

        @Override
        GameTexture getTexture() {
            return texture;
        }

        public DemonicAircutProjectile(Level level, Mob owner, float x, float y, float targetX, float targetY, float speed, int distance, GameDamage damage, int knockback) {
            super(level, owner, x, y, targetX, targetY, speed, distance, damage, knockback);
        }

        public DemonicAircutProjectile() {
        }
    }

    public static class UnstableGelAircutProjectile
    extends AircutProjectile {
        public static GameTexture texture;

        @Override
        Color getColor() {
            return AphColors.unstableGel;
        }

        @Override
        GameTexture getTexture() {
            return texture;
        }

        public UnstableGelAircutProjectile(Level level, Mob owner, float x, float y, float targetX, float targetY, float speed, int distance, GameDamage damage, int knockback) {
            super(level, owner, x, y, targetX, targetY, speed, distance, damage, knockback);
        }

        public UnstableGelAircutProjectile() {
        }
    }

    public static class GoldAircutProjectile
    extends AircutProjectile {
        public static GameTexture texture;

        @Override
        Color getColor() {
            return AphColors.gold;
        }

        @Override
        GameTexture getTexture() {
            return texture;
        }

        public GoldAircutProjectile(Level level, Mob owner, float x, float y, float targetX, float targetY, float speed, int distance, GameDamage damage, int knockback) {
            super(level, owner, x, y, targetX, targetY, speed, distance, damage, knockback);
        }

        public GoldAircutProjectile() {
        }
    }

    public static class IronAircutProjectile
    extends AircutProjectile {
        public static GameTexture texture;

        @Override
        Color getColor() {
            return AphColors.iron;
        }

        @Override
        GameTexture getTexture() {
            return texture;
        }

        public IronAircutProjectile(Level level, Mob owner, float x, float y, float targetX, float targetY, float speed, int distance, GameDamage damage, int knockback) {
            super(level, owner, x, y, targetX, targetY, speed, distance, damage, knockback);
        }

        public IronAircutProjectile() {
        }
    }

    public static class CopperAircutProjectile
    extends AircutProjectile {
        public static GameTexture texture;

        @Override
        Color getColor() {
            return AphColors.copper;
        }

        @Override
        GameTexture getTexture() {
            return texture;
        }

        public CopperAircutProjectile(Level level, Mob owner, float x, float y, float targetX, float targetY, float speed, int distance, GameDamage damage, int knockback) {
            super(level, owner, x, y, targetX, targetY, speed, distance, damage, knockback);
        }

        public CopperAircutProjectile() {
        }
    }
}

