/*
 * Decompiled with CFR 0.152.
 */
package aphorea.objects;

import aphorea.objects.AphCraftingStationObject;
import aphorea.registry.AphTech;
import aphorea.utils.AphColors;
import java.awt.Rectangle;
import java.util.List;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.entity.mobs.PlayerMob;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.texture.TextureDrawOptions;
import necesse.gfx.drawOptions.texture.TextureDrawOptionsEnd;
import necesse.gfx.drawables.LevelSortedDrawable;
import necesse.gfx.drawables.OrderableDrawables;
import necesse.gfx.gameTexture.GameTexture;
import necesse.inventory.recipe.Tech;
import necesse.level.gameObject.GameObject;
import necesse.level.maps.Level;
import necesse.level.maps.light.GameLight;

public class RunesTable
extends AphCraftingStationObject {
    public GameTexture texture;

    public RunesTable() {
        super(new Rectangle(32, 32));
        this.mapColor = AphColors.wood;
        this.isLightTransparent = true;
    }

    public int getCraftingCategoryDepth() {
        return 2;
    }

    public void loadTextures() {
        super.loadTextures();
        this.texture = GameTexture.fromFile((String)"objects/runestable");
    }

    public Rectangle getCollision(Level level, int x, int y, int rotation) {
        return rotation % 2 == 0 ? new Rectangle(x * 32 + 8, y * 32 + 8, 16, 20) : new Rectangle(x * 32 + 5, y * 32 + 14, 22, 16);
    }

    public void addDrawables(List<LevelSortedDrawable> list, OrderableDrawables tileList, Level level, int tileX, int tileY, TickManager tickManager, GameCamera camera, PlayerMob perspective) {
        GameLight light = level.getLightLevel(tileX, tileY);
        int drawX = camera.getTileDrawX(tileX);
        int drawY = camera.getTileDrawY(tileY);
        byte rotation = level.getObjectRotation(tileX, tileY);
        TextureDrawOptionsEnd options = this.texture.initDraw().sprite(rotation % 4, 0, 32, this.texture.getHeight()).addObjectDamageOverlay((GameObject)this, level, tileX, tileY).light(light).pos(drawX, drawY - (this.texture.getHeight() - 32));
        list.add(new LevelSortedDrawable((GameObject)this, tileX, tileY, (TextureDrawOptions)options){
            final /* synthetic */ TextureDrawOptions val$options;
            {
                this.val$options = textureDrawOptions;
                super(arg0, arg1, arg2);
            }

            public int getSortY() {
                return 20;
            }

            public void draw(TickManager tickManager) {
                this.val$options.draw();
            }
        });
    }

    public void drawPreview(Level level, int tileX, int tileY, int rotation, float alpha, PlayerMob player, GameCamera camera) {
        int drawX = camera.getTileDrawX(tileX);
        int drawY = camera.getTileDrawY(tileY);
        this.texture.initDraw().sprite(rotation % 4, 0, 32, this.texture.getHeight()).addObjectDamageOverlay((GameObject)this, level, tileX, tileY).alpha(alpha).draw(drawX, drawY - (this.texture.getHeight() - 32));
    }

    public Tech[] getCraftingTechs() {
        return new Tech[]{AphTech.RUNES};
    }
}

