/*
 * Decompiled with CFR 0.152.
 */
package aphorea.items.tools.weapons.range.greatbow;

import aphorea.items.vanillaitemtypes.weapons.AphGreatbowProjectileToolItem;
import aphorea.packets.AphCustomPushPacket;
import aphorea.utils.AphColors;
import aphorea.utils.AphMaths;
import java.awt.geom.Point2D;
import java.util.Objects;
import necesse.engine.localization.Localization;
import necesse.engine.network.Packet;
import necesse.engine.network.gameNetworkData.GNDItemMap;
import necesse.engine.registries.BuffRegistry;
import necesse.engine.registries.ItemRegistry;
import necesse.engine.util.GameBlackboard;
import necesse.engine.util.GameMath;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.itemAttacker.ItemAttackSlot;
import necesse.entity.mobs.itemAttacker.ItemAttackerMob;
import necesse.entity.projectile.Projectile;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.Item;
import necesse.inventory.item.arrowItem.ArrowItem;
import necesse.level.maps.Level;

public class GelGreatbow
extends AphGreatbowProjectileToolItem {
    public GelGreatbow() {
        super(200);
        this.rarity = Item.Rarity.NORMAL;
        this.attackAnimTime.setBaseValue(700);
        this.attackDamage.setBaseValue(15.0f).setUpgradedValue(1.0f, 65.0f);
        this.attackRange.setBaseValue(800);
        this.velocity.setBaseValue(300);
        this.attackXOffset = 10;
        this.attackYOffset = 34;
        this.particleColor = AphColors.gel;
    }

    protected void fireProjectiles(Level level, int x, int y, ItemAttackerMob attackerMob, InventoryItem item, int seed, ArrowItem arrow, boolean dropItem, GNDItemMap mapContent) {
        for (int i = 0; i < 2; ++i) {
            float endY;
            float endX;
            float[] vector = AphMaths.perpendicularVector(x, y, attackerMob.x, attackerMob.y);
            if (i == 0) {
                endX = (float)x + vector[0] / 9.0f;
                endY = (float)y + vector[1] / 9.0f;
            } else {
                endX = (float)x - vector[0] / 9.0f;
                endY = (float)y - vector[1] / 9.0f;
            }
            super.fireProjectiles(level, (int)endX, (int)endY, attackerMob, item, seed, arrow, i == 1, mapContent);
        }
    }

    public InventoryItem superOnAttack(Level level, int x, int y, ItemAttackerMob attackerMob, int attackHeight, InventoryItem item, ItemAttackSlot slot, int animAttack, int seed, GNDItemMap mapContent) {
        super.superOnAttack(level, x, y, attackerMob, attackHeight, item, slot, animAttack, seed, mapContent);
        attackerMob.buffManager.addBuff(new ActiveBuff(BuffRegistry.FOW_ACTIVE, (Mob)attackerMob, 0.15f, null), level.isServer());
        attackerMob.buffManager.forceUpdateBuffs();
        if (attackerMob.isServer()) {
            int strength = 50;
            Point2D.Float dir = GameMath.normalize((float)((float)x - attackerMob.x), (float)((float)y - attackerMob.y));
            level.getServer().network.sendToClientsAtEntireLevel((Packet)new AphCustomPushPacket((Mob)attackerMob, -dir.x, -dir.y, strength), level);
        }
        return item;
    }

    public ListGameTooltips getPreEnchantmentTooltips(InventoryItem item, PlayerMob perspective, GameBlackboard blackboard) {
        ListGameTooltips tooltips = super.getPreEnchantmentTooltips(item, perspective, blackboard);
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"stikybuff1"));
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"twoarrows"));
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"gelgreatbow"));
        return tooltips;
    }

    public Projectile getProjectile(Level level, int x, int y, ItemAttackerMob attackerMob, InventoryItem item, int seed, ArrowItem arrow, boolean consumeAmmo, GNDItemMap mapContent) {
        ArrowItem shotArrow = arrow;
        if (Objects.equals(arrow.getStringID(), "stonearrow")) {
            shotArrow = (ArrowItem)ItemRegistry.getItem((String)"gelarrow");
        }
        return super.getProjectile(level, x, y, attackerMob, item, seed, shotArrow, consumeAmmo, mapContent);
    }
}

