/*
 * Decompiled with CFR 0.152.
 */
package aphorea.buffs.Trinkets.Periapt;

import aphorea.AphDependencies;
import aphorea.utils.AphColors;
import java.awt.Color;
import necesse.engine.localization.Localization;
import necesse.engine.registries.DamageTypeRegistry;
import necesse.engine.util.GameRandom;
import necesse.entity.Entity;
import necesse.entity.ParticleTypeSwitcher;
import necesse.entity.levelEvent.LevelEvent;
import necesse.entity.levelEvent.mobAbilityLevelEvent.MobHealthChangeEvent;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.MobWasHitEvent;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.buffs.BuffEventSubscriber;
import necesse.entity.mobs.buffs.staticBuffs.armorBuffs.trinketBuffs.TrinketBuff;
import necesse.entity.particle.Particle;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.trinketItem.TrinketItem;

public class AbysmalPeriaptBuff
extends TrinketBuff {
    public ParticleTypeSwitcher particleTypeSwitcher = new ParticleTypeSwitcher(new Particle.GType[]{Particle.GType.CRITICAL, Particle.GType.IMPORTANT_COSMETIC, Particle.GType.COSMETIC});
    public boolean hasRPGMod = AphDependencies.checkRPGMod();

    public void init(ActiveBuff buff, BuffEventSubscriber eventSubscriber) {
    }

    public void onHasAttacked(ActiveBuff buff, MobWasHitEvent event) {
        if (!event.wasPrevented && event.target.isHostile) {
            int heal;
            Mob owner = event.attacker.getAttackOwner();
            if (event.damageType.equals(DamageTypeRegistry.MAGIC) && (heal = (int)Math.ceil((float)event.damage * (this.hasRPGMod ? 0.002f : 0.02f))) > 0) {
                if (owner.isServer()) {
                    MobHealthChangeEvent healEvent = new MobHealthChangeEvent(owner, heal);
                    owner.getLevel().entityManager.events.add((LevelEvent)healEvent);
                }
                for (int i = 0; i < 20; ++i) {
                    int angle = (int)(360.0f + GameRandom.globalRandom.nextFloat() * 360.0f);
                    float dx = (float)Math.sin(Math.toRadians(angle)) * (float)GameRandom.globalRandom.getIntBetween(30, 50);
                    float dy = (float)Math.cos(Math.toRadians(angle)) * (float)GameRandom.globalRandom.getIntBetween(30, 50);
                    owner.getLevel().entityManager.addParticle((Entity)owner, this.particleTypeSwitcher.next()).movesFriction(dx, dy, 0.8f).color((Color)GameRandom.globalRandom.getOneOf((Object[])AphColors.paletteDeepDemonic)).heightMoves(10.0f, 30.0f).lifeTime(500);
                }
            }
        }
    }

    public ListGameTooltips getTrinketTooltip(TrinketItem trinketItem, InventoryItem item, PlayerMob perspective) {
        ListGameTooltips tooltips = super.getTrinketTooltip(trinketItem, item, perspective);
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"demonicperiapt", (String)"amount", (String)(this.hasRPGMod ? "0.2" : "2")));
        if (this.hasRPGMod) {
            tooltips.add(Localization.translate((String)"itemtooltip", (String)"rpgmodnerf"));
        }
        return tooltips;
    }
}

