/*
 * Decompiled with CFR 0.152.
 */
package cheatequipment.main;

import necesse.engine.localization.Localization;
import necesse.engine.network.Packet;
import necesse.engine.network.gameNetworkData.GNDItemMap;
import necesse.engine.network.packet.PacketPlayerGeneral;
import necesse.engine.sound.PrimitiveSoundEmitter;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.engine.util.GameBlackboard;
import necesse.entity.mobs.PlayerMob;
import necesse.gfx.GameResources;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.Item;
import necesse.inventory.item.placeableItem.consumableItem.ConsumableItem;
import necesse.level.maps.Level;

public class GGMagicHeart
extends ConsumableItem {
    public GGMagicHeart() {
        super(1, true);
        this.rarity = Item.Rarity.LEGENDARY;
        this.allowRightClickToConsume = true;
        this.worldDrawSize = 32;
    }

    public InventoryItem onPlace(Level level, int x, int y, PlayerMob player, int seed, InventoryItem item, GNDItemMap mapContent) {
        player.setMaxHealth(10000000);
        player.setMaxMana(10000000);
        if (level.isServer()) {
            level.getServer().network.sendToAllClientsExcept((Packet)new PacketPlayerGeneral(player.getServerClient()), player.getServerClient());
        } else if (level.isClient()) {
            SoundManager.playSound((GameSound)GameResources.eat, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)player));
        }
        if (this.isSingleUse(player)) {
            item.setAmount(item.getAmount() - 1);
        }
        return item;
    }

    public ListGameTooltips getTooltips(InventoryItem item, PlayerMob perspective, GameBlackboard blackboard) {
        ListGameTooltips tooltips = super.getTooltips(item, perspective, blackboard);
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"consumetip"));
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"GGMagicHearttip"));
        return tooltips;
    }
}

