/*
 * Decompiled with CFR 0.152.
 */
package moretrinketslots.modclasses.settings;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import moretrinketslots.modclasses.items.LootTableFunctions;
import moretrinketslots.modclasses.items.TrinketSlotsItemConfig;
import necesse.entity.mobs.hostile.bosses.FlyingSpiritsHead;
import necesse.level.maps.Level;

public class MTSConfig {
    public static String modName = "MORETRINKETSLOTS";
    public static String modAcronym = "MTS";
    public static String itemPrefix = "moretrinketslots_";
    public static float brokerValue = 100.0f;
    public static int initialSlots = 0;
    public static Level level;
    public static Map<String, TrinketSlotsItemConfig> items;

    public static int getDefaultInitialSlots() {
        return 4;
    }

    public static Map<String, TrinketSlotsItemConfig> getDefaultItems() {
        TreeMap<String, TrinketSlotsItemConfig> items = new TreeMap<String, TrinketSlotsItemConfig>();
        items.put("evilsprotector", new TrinketSlotsItemConfig(itemPrefix + "evilsprotector", 0, 0, 1));
        items.put("queenspider", new TrinketSlotsItemConfig(itemPrefix + "queenspider", 0, 0, 1));
        items.put("voidwizard", new TrinketSlotsItemConfig("emptypendant", 5, 5, 1));
        items.put("swampguardian", new TrinketSlotsItemConfig(itemPrefix + "swampguardian", 0, 0, 1));
        items.put("ancientvulture", new TrinketSlotsItemConfig(itemPrefix + "ancientvulture", 0, 0, 1));
        items.put("piratecaptain", new TrinketSlotsItemConfig("piratesheath", 6, 6, 1));
        items.put("reaper", new TrinketSlotsItemConfig(itemPrefix + "reaper", 0, 0, 1));
        items.put("cryoqueen", new TrinketSlotsItemConfig(itemPrefix + "cryoqueen", 0, 0, 1));
        items.put("thecursedcrone", new TrinketSlotsItemConfig(itemPrefix + "thecursedcrone", 7, 7, 1));
        items.put("pestwarden", new TrinketSlotsItemConfig(itemPrefix + "pestwarden", 0, 0, 1));
        items.put(FlyingSpiritsHead.class.getName(), new TrinketSlotsItemConfig(itemPrefix + "sageandgrit", 0, 0, 1));
        items.put("fallenwizard", new TrinketSlotsItemConfig("wizardsocket", 8, 8, 1));
        items.put("motherslime", new TrinketSlotsItemConfig(itemPrefix + "motherslime", 0, 0, 1));
        items.put("nightswarm", new TrinketSlotsItemConfig(itemPrefix + "nightswarm", 0, 0, 1));
        return items;
    }

    public static void emptyItems() {
        items = new TreeMap<String, TrinketSlotsItemConfig>();
    }

    public static void setDefault() {
        initialSlots = MTSConfig.getDefaultInitialSlots();
        MTSConfig.emptyItems();
        MTSConfig.setItems(MTSConfig.getDefaultItems());
    }

    public static void setInitialSlots(int newInitialSlots) {
        initialSlots = newInitialSlots;
    }

    public static void setItems(Map<String, TrinketSlotsItemConfig> newItems) {
        LootTableFunctions.removeItemsFromLootTables();
        for (Map.Entry<String, TrinketSlotsItemConfig> entry : newItems.entrySet()) {
            items.put(entry.getKey(), new TrinketSlotsItemConfig(entry.getValue()));
        }
    }

    public static void set(int newInitialSlots, Map<String, TrinketSlotsItemConfig> newItems) {
        MTSConfig.setInitialSlots(newInitialSlots);
        MTSConfig.setItems(newItems);
    }

    public static boolean containsItemID(String searchItemID) {
        for (Map.Entry<String, TrinketSlotsItemConfig> entry : items.entrySet()) {
            if (!Objects.equals(entry.getValue().itemID, searchItemID)) continue;
            return true;
        }
        return false;
    }

    public static List<TrinketSlotsItemConfig> getConfigs(String searchItemID) {
        ArrayList<TrinketSlotsItemConfig> outputList = new ArrayList<TrinketSlotsItemConfig>();
        for (Map.Entry<String, TrinketSlotsItemConfig> entry : items.entrySet()) {
            if (!Objects.equals(entry.getValue().itemID, searchItemID)) continue;
            outputList.add(entry.getValue());
        }
        return outputList;
    }

    public static TrinketSlotsItemConfig getConsolidatedConfig(String searchItemID) {
        List<TrinketSlotsItemConfig> listOfConfigs = MTSConfig.getConfigs(searchItemID);
        if (listOfConfigs.isEmpty()) {
            return new TrinketSlotsItemConfig("searchItemID", 0, 0, 0, 0.0f);
        }
        if (listOfConfigs.size() == 1) {
            return listOfConfigs.get(0);
        }
        TrinketSlotsItemConfig outputConfig = listOfConfigs.get(0);
        for (TrinketSlotsItemConfig itemConfig : listOfConfigs) {
            outputConfig.minSlots = Math.min(outputConfig.minSlots, itemConfig.minSlots);
            outputConfig.maxSlots = Math.max(outputConfig.maxSlots, itemConfig.maxSlots);
            outputConfig.increment += itemConfig.increment;
            outputConfig.brokerValue += itemConfig.brokerValue;
        }
        outputConfig.increment /= listOfConfigs.size();
        outputConfig.brokerValue /= (float)listOfConfigs.size();
        return outputConfig;
    }

    public static List<TrinketSlotsItemConfig> getConsolidatedConfigs(Map<String, TrinketSlotsItemConfig> items) {
        ArrayList<String> uniqueIDS = new ArrayList<String>();
        for (Map.Entry<String, TrinketSlotsItemConfig> entry : items.entrySet()) {
            if (uniqueIDS.contains(entry.getValue().itemID)) continue;
            uniqueIDS.add(entry.getValue().itemID);
        }
        ArrayList<TrinketSlotsItemConfig> outputList = new ArrayList<TrinketSlotsItemConfig>();
        for (String uniqueID : uniqueIDS) {
            outputList.add(MTSConfig.getConsolidatedConfig(uniqueID));
        }
        return outputList;
    }

    public static int getMaxSlots() {
        int max = 0;
        for (Map.Entry<String, TrinketSlotsItemConfig> entry : items.entrySet()) {
            max = Math.max(max, entry.getValue().maxSlots);
        }
        return max;
    }

    static {
        items = new TreeMap<String, TrinketSlotsItemConfig>();
        MTSConfig.setItems(MTSConfig.getDefaultItems());
    }
}

