/*
 * Decompiled with CFR 0.152.
 */
package moretrinketslots.modclasses.items;

import java.awt.geom.Line2D;
import moretrinketslots.modclasses.items.TrinketSlotsItemConfig;
import moretrinketslots.modclasses.settings.MTSConfig;
import necesse.engine.localization.Localization;
import necesse.engine.network.Packet;
import necesse.engine.network.gameNetworkData.GNDItemMap;
import necesse.engine.network.packet.PacketUpdateTrinketSlots;
import necesse.engine.network.server.ServerClient;
import necesse.engine.util.GameBlackboard;
import necesse.entity.mobs.PlayerMob;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.Item;
import necesse.inventory.item.placeableItem.consumableItem.ChangeTrinketSlotsItem;
import necesse.level.maps.Level;

public class IncrementalTrinketSlotsItem
extends ChangeTrinketSlotsItem {
    public String itemID;

    public IncrementalTrinketSlotsItem(String itemID) {
        super(0);
        this.itemID = itemID;
        this.rarity = Item.Rarity.UNIQUE;
    }

    public ListGameTooltips getTooltips(InventoryItem item, PlayerMob perspective, GameBlackboard blackboard) {
        ListGameTooltips tooltips = super.getTooltips(item, perspective, blackboard);
        tooltips.add(Localization.translate((String)"itemtooltip", (String)(this.itemID + "tip")));
        return tooltips;
    }

    public InventoryItem onPlace(Level level, int x, int y, PlayerMob player, int seed, InventoryItem item, GNDItemMap mapContent) {
        TrinketSlotsItemConfig itemConfig = MTSConfig.getConsolidatedConfig(this.itemID);
        if (level.isServer() && itemConfig.increment > 0) {
            player.getInv().equipment.changeTrinketSlotsSize(IncrementalTrinketSlotsItem.getNewSize(player, itemConfig));
            player.equipmentBuffManager.updateTrinketBuffs();
            ServerClient serverClient = player.getServerClient();
            serverClient.closeContainer(false);
            serverClient.updateInventoryContainer();
            if (serverClient.achievementsLoaded()) {
                serverClient.achievements().MAGICAL_DROP.markCompleted(serverClient);
            }
            level.getServer().network.sendToAllClients((Packet)new PacketUpdateTrinketSlots(serverClient));
        }
        if (this.isSingleUse(player)) {
            item.setAmount(item.getAmount() - 1);
        }
        return item;
    }

    public String canPlace(Level level, int x, int y, PlayerMob player, Line2D playerPositionLine, InventoryItem item, GNDItemMap mapContent) {
        int maxSlots = -1;
        if (MTSConfig.containsItemID(this.itemID)) {
            maxSlots = MTSConfig.getConsolidatedConfig((String)this.itemID).maxSlots;
            if (player.getInv().equipment.getTrinketSlotsSize() < maxSlots || maxSlots < 0) {
                return null;
            }
        }
        return String.format("incorrectslots (playerSlots = %d, maxSlots = %d)", player.getInv().equipment.getTrinketSlotsSize(), maxSlots);
    }

    private static int getNewSize(PlayerMob player, TrinketSlotsItemConfig itemConfig) {
        int newSize = Math.max(player.getInv().equipment.getTrinketSlotsSize() + itemConfig.increment, itemConfig.minSlots);
        if (itemConfig.maxSlots >= 0) {
            newSize = Math.min(newSize, itemConfig.maxSlots);
        }
        return newSize;
    }
}

