/*
 * Decompiled with CFR 0.152.
 */
package moretrinketslots.commands;

import java.util.LinkedList;
import java.util.Objects;
import moretrinketslots.modclasses.settings.MTSConfig;
import necesse.engine.commands.CmdParameter;
import necesse.engine.commands.CommandLog;
import necesse.engine.commands.ModularChatCommand;
import necesse.engine.commands.PermissionLevel;
import necesse.engine.commands.parameterHandlers.IntParameterHandler;
import necesse.engine.commands.parameterHandlers.MultiParameterHandler;
import necesse.engine.commands.parameterHandlers.ParameterHandler;
import necesse.engine.commands.parameterHandlers.PresetStringParameterHandler;
import necesse.engine.commands.parameterHandlers.ServerClientParameterHandler;
import necesse.engine.localization.message.GameMessage;
import necesse.engine.localization.message.GameMessageBuilder;
import necesse.engine.network.Packet;
import necesse.engine.network.client.Client;
import necesse.engine.network.packet.PacketPlayerInventory;
import necesse.engine.network.packet.PacketUpdateTrinketSlots;
import necesse.engine.network.server.Server;
import necesse.engine.network.server.ServerClient;
import necesse.engine.network.server.ServerSaveHandler;
import necesse.engine.save.LoadData;
import necesse.engine.util.GameRandom;
import necesse.engine.world.WorldFile;
import necesse.inventory.InventorySlot;

public class TrinketSlotsCommand
extends ModularChatCommand {
    ServerSaveHandler.SaveInterruptedOrFinishedEventHandler saveHandler = new ServerSaveHandler.SaveInterruptedOrFinishedEventHandler(){

        public void onSaveInterrupted(ServerSaveHandler newSaveHandler) {
            System.out.println("World save interrupted, changes to trinket slots not applied properly");
        }

        public void onSaveFinished() {
            System.out.println("World saved successfully");
        }
    };

    public TrinketSlotsCommand() {
        super(MTSConfig.modAcronym + ".trinketslots", "Change player(s) trinket slots size", PermissionLevel.OWNER, false, new CmdParameter[]{new CmdParameter("player/all/online/offline", (ParameterHandler)new MultiParameterHandler(new ParameterHandler[]{new PresetStringParameterHandler(new String[]{"all", "online", "offline"}), new ServerClientParameterHandler(false, true)})), new CmdParameter("set/reset/max/adjust", (ParameterHandler)new PresetStringParameterHandler(new String[]{"set", "reset", "max", "adjust"})), new CmdParameter("new amount", (ParameterHandler)new IntParameterHandler(Integer.valueOf(-1)), true, new CmdParameter[0])});
    }

    public ServerClient moveTrinketsToInventory(ServerClient target, int newAmount) {
        if (target.playerMob.getInv().equipment.getTrinketSlotsSize() > newAmount) {
            int maxSlots = target.playerMob.getInv().equipment.getTrinketSlotsSize();
            for (int trinketSlotPos = 0; trinketSlotPos < maxSlots - newAmount; ++trinketSlotPos) {
                InventorySlot trinketSlot = target.playerMob.getInv().equipment.getSelectedTrinketsSlot(maxSlots - 1 - trinketSlotPos);
                if (trinketSlot.isSlotClear()) continue;
                boolean emptySlotFound = false;
                for (int invPos = 0; invPos < target.playerMob.getInv().main.getSize(); ++invPos) {
                    if (!target.playerMob.getInv().main.isSlotClear(invPos)) continue;
                    target.playerMob.getInv().main.setItem(invPos, trinketSlot.getItem());
                    emptySlotFound = true;
                    break;
                }
                if (emptySlotFound) continue;
                target.playerMob.dropItem(trinketSlot.getItem());
            }
        }
        return target;
    }

    public void onlinePlayerTrinketsChangeSize(ServerClient target, int newAmount) {
        if (target.playerMob.getInv().equipment.getTrinketSlotsSize() != newAmount) {
            target = this.moveTrinketsToInventory(target, newAmount);
            target.playerMob.getInv().equipment.changeTrinketSlotsSize(newAmount);
            target.playerMob.equipmentBuffManager.updateTrinketBuffs();
            target.closeContainer(false);
            target.updateInventoryContainer();
            target.getServer().network.sendToAllClients((Packet)new PacketUpdateTrinketSlots(target));
            target.getServer().network.sendToAllClients((Packet)new PacketPlayerInventory(target));
        }
    }

    public int getAdjustAmount(int currentSlots) {
        if (currentSlots < MTSConfig.initialSlots) {
            return MTSConfig.initialSlots;
        }
        return Math.min(currentSlots, MTSConfig.getMaxSlots());
    }

    public boolean isPlayerOnline(Server server, long auth) {
        for (int i = 0; i < server.getSlots(); ++i) {
            if (server.getClient(i) == null || server.getClient((int)i).authentication != auth) continue;
            return true;
        }
        return false;
    }

    public void runModular(Client client, Server server, ServerClient serverClient, Object[] args, String[] errors, CommandLog logs) {
        GameMessageBuilder msg = new GameMessageBuilder();
        String action = (String)args[1];
        int newSlotAmount = 0;
        boolean adjustFlag = false;
        switch (action) {
            case "reset": {
                newSlotAmount = MTSConfig.initialSlots;
                break;
            }
            case "max": {
                newSlotAmount = MTSConfig.getMaxSlots();
                break;
            }
            case "adjust": {
                adjustFlag = true;
                break;
            }
            case "set": {
                newSlotAmount = (Integer)args[2];
                if (newSlotAmount >= 0) break;
                msg.append("Missing/invalid argument <new amount>");
                logs.add((GameMessage)msg);
                return;
            }
        }
        Object[] subArgs = (Object[])args[0];
        ServerClient targetClient = (ServerClient)subArgs[1];
        if (targetClient != null) {
            if (adjustFlag) {
                int playerSlots = targetClient.playerMob.getInv().equipment.getTrinketSlotsSize();
                newSlotAmount = playerSlots < MTSConfig.initialSlots ? MTSConfig.initialSlots : (playerSlots > MTSConfig.getMaxSlots() ? MTSConfig.getMaxSlots() : targetClient.playerMob.getInv().equipment.getTrinketSlotsSize());
            }
            this.onlinePlayerTrinketsChangeSize(targetClient, newSlotAmount);
            if (adjustFlag) {
                msg.append(String.format("Adjusted %s's trinket slots to be within %d and %d", targetClient.playerMob.playerName, MTSConfig.initialSlots, MTSConfig.getMaxSlots()));
            } else {
                msg.append(String.format("Changed %s's trinket slots to %d", targetClient.playerMob.playerName, newSlotAmount));
            }
            logs.add((GameMessage)msg);
            server.startFullSave(true, true, null);
            return;
        }
        String target = (String)subArgs[0];
        if (Objects.equals(target, "all") || Objects.equals(target, "online")) {
            for (int i = 0; i < server.getSlots(); ++i) {
                if (server.getClient(i) == null) continue;
                if (adjustFlag) {
                    newSlotAmount = this.getAdjustAmount(server.getClient((int)i).playerMob.getInv().equipment.getTrinketSlotsSize());
                }
                this.onlinePlayerTrinketsChangeSize(server.getClient(i), newSlotAmount);
            }
        }
        if (!server.world.settings.allowOutsideCharacters && (Objects.equals(target, "all") || Objects.equals(target, "offline"))) {
            LinkedList playerFiles = server.world.fileSystem.getPlayerFiles();
            for (WorldFile playerFile : playerFiles) {
                if (new LoadData(playerFile).isEmpty()) continue;
                String fileName = playerFile.getFileName().toString();
                long fileNameLong = Long.valueOf(fileName = fileName.substring(0, fileName.length() - 4), 10);
                if (this.isPlayerOnline(server, fileNameLong)) continue;
                ServerClient offlinePlayerClient = server.world.loadClient(playerFile, GameRandom.globalRandom.nextLong(), null, -1, fileNameLong);
                if (adjustFlag) {
                    newSlotAmount = this.getAdjustAmount(offlinePlayerClient.playerMob.getInv().equipment.getTrinketSlotsSize());
                }
                if (offlinePlayerClient.playerMob.getInv().equipment.getTrinketSlotsSize() != newSlotAmount) {
                    offlinePlayerClient = this.moveTrinketsToInventory(offlinePlayerClient, newSlotAmount);
                    offlinePlayerClient.playerMob.getInv().equipment.changeTrinketSlotsSize(newSlotAmount);
                    offlinePlayerClient.saveClient();
                }
                offlinePlayerClient.dispose();
            }
        }
        if (adjustFlag) {
            msg.append(String.format("Adjusted %s players trinket slots to be within %d and %d", target, MTSConfig.initialSlots, MTSConfig.getMaxSlots()));
        } else {
            msg.append(String.format("Changed %s players trinket slots to %d", target, newSlotAmount));
        }
        logs.add((GameMessage)msg);
        server.startFullSave(true, true, this.saveHandler);
    }
}

