/*
 * Decompiled with CFR 0.152.
 */
package moretrinketslots.commands;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import moretrinketslots.modclasses.items.TrinketSlotsItemConfig;
import moretrinketslots.modclasses.settings.MTSConfig;
import necesse.engine.commands.CmdParameter;
import necesse.engine.commands.CommandLog;
import necesse.engine.commands.ModularChatCommand;
import necesse.engine.commands.PermissionLevel;
import necesse.engine.commands.parameterHandlers.ParameterHandler;
import necesse.engine.commands.parameterHandlers.PresetStringParameterHandler;
import necesse.engine.localization.message.GameMessage;
import necesse.engine.localization.message.GameMessageBuilder;
import necesse.engine.network.client.Client;
import necesse.engine.network.server.Server;
import necesse.engine.network.server.ServerClient;
import necesse.engine.registries.ItemRegistry;
import necesse.engine.registries.MobRegistry;
import necesse.entity.mobs.Mob;
import necesse.gfx.GameColor;
import necesse.level.maps.Level;

public class InfoCommand
extends ModularChatCommand {
    public InfoCommand() {
        super(MTSConfig.modAcronym + ".info", "Displays information about the mod's settings", PermissionLevel.USER, false, new CmdParameter[]{new CmdParameter("slots/bosses/items", (ParameterHandler)new PresetStringParameterHandler(new String[]{"slots", "bosses", "items", "all"}), true, new CmdParameter[0])});
    }

    public void runModular(Client client, Server server, ServerClient serverClient, Object[] args, String[] errors, CommandLog logs) {
        String option = (String)args[0];
        option = option == null || option.isEmpty() ? "all" : option.toLowerCase();
        GameMessageBuilder msg = new GameMessageBuilder();
        String defaultColor = GameColor.WHITE.getColorCode();
        if (option.equals("all")) {
            msg.append(String.format("\n%sHere is all the information about %s\n", GameColor.ITEM_QUEST.getColorCode(), MTSConfig.modName));
        }
        if (option.equals("all") || option.equals("slots")) {
            msg.append(String.format("\n%sPlayers%s start with %s%d%s slots\n", GameColor.ITEM_QUEST.getColorCode(), defaultColor, GameColor.GREEN.getColorCode(), MTSConfig.initialSlots, defaultColor));
            msg.append(String.format("%sPlayers%s can get up to %s%d%s slots\n", GameColor.ITEM_QUEST.getColorCode(), defaultColor, GameColor.RED.getColorCode(), MTSConfig.getMaxSlots(), defaultColor));
        }
        if (option.equals("all") || option.equals("bosses")) {
            LinkedHashMap sortedMap = MTSConfig.items.entrySet().stream().sorted(Map.Entry.comparingByValue()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> oldValue, LinkedHashMap::new));
            Set keys = sortedMap.keySet();
            msg.append(String.format("\n%sThe following bosses drop items to increase trinket slots:\n", defaultColor));
            for (String bossKey : keys) {
                String bossName;
                TrinketSlotsItemConfig itemConfig = (TrinketSlotsItemConfig)sortedMap.get(bossKey);
                if (itemConfig.minSlots <= 0 || itemConfig.maxSlots == 0 || itemConfig.increment <= 0) continue;
                try {
                    Class<?> cls = Class.forName(bossKey);
                    String[] splitName = cls.toString().split("\\.");
                    bossName = splitName[splitName.length - 1];
                }
                catch (Exception e) {
                    try {
                        Mob tempMob = MobRegistry.getMob((String)bossKey, (Level)MTSConfig.level);
                        bossName = MobRegistry.getDisplayName((int)tempMob.getID());
                    }
                    catch (Exception j) {
                        bossName = bossKey;
                    }
                }
                msg.append(String.format("%s%s%s drops %s%s%s if under %s%d%s slots\n", GameColor.GRAY.getColorCode(), bossName, defaultColor, GameColor.LIGHT_GRAY.getColorCode(), ItemRegistry.getDisplayName((int)ItemRegistry.getItemID((String)itemConfig.itemID)), defaultColor, GameColor.RED.getColorCode(), itemConfig.maxSlots, defaultColor));
            }
        }
        if (option.equals("all") || option.equals("items")) {
            msg.append(String.format("\n%sThe following items can increase trinket slots:\n", defaultColor));
            List<TrinketSlotsItemConfig> consolidatedConfigs = MTSConfig.getConsolidatedConfigs(MTSConfig.items);
            Collections.sort(consolidatedConfigs);
            for (TrinketSlotsItemConfig itemConfig : consolidatedConfigs) {
                if (itemConfig.minSlots <= 0 || itemConfig.maxSlots == 0 || itemConfig.increment <= 0) continue;
                msg.append(String.format("%s%s%s - min:%s%d%s, max:%s%d%s, increment:%s%d%s\n", GameColor.GRAY.getColorCode(), ItemRegistry.getDisplayName((int)ItemRegistry.getItemID((String)itemConfig.itemID)), defaultColor, GameColor.GREEN.getColorCode(), itemConfig.minSlots, defaultColor, GameColor.RED.getColorCode(), itemConfig.maxSlots, defaultColor, GameColor.BLUE.getColorCode(), itemConfig.increment, defaultColor));
            }
        }
        logs.add((GameMessage)msg);
    }
}

