/*
 * Decompiled with CFR 0.152.
 */
package interactions.Util;

import java.awt.geom.Line2D;
import java.util.Optional;
import necesse.engine.network.Packet;
import necesse.engine.network.packet.PacketMobChat;
import necesse.engine.network.server.Server;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.ai.behaviourTree.util.TargetFinderDistance;
import necesse.entity.mobs.friendly.human.HumanMob;

public class MobUtils {
    private static final TargetFinderDistance<Mob> targetFinder = new TargetFinderDistance(0);

    public static <T extends Mob> void SendMobMessage(T mob, String message) {
        if (mob.getLevel().isClient()) {
            return;
        }
        Server server = mob.getServer();
        if (server == null) {
            return;
        }
        mob.getLevel().getServer().network.sendToClientsWithRegion((Packet)new PacketMobChat(mob.getUniqueID(), message), mob.getLevel(), mob.getLevel().regionManager.getRegionCoordByTile(mob.getTileX()), mob.getLevel().regionManager.getRegionCoordByTile(mob.getTileY()));
    }

    public static <T extends HumanMob> HumanMob GetNearbyHumanMob(T t, int distance, boolean lineOfSight) {
        if (distance > MobUtils.targetFinder.searchDistance) {
            MobUtils.targetFinder.searchDistance = distance;
        }
        Optional result = targetFinder.streamMobsInRange(t.getPositionPoint(), t).filter(mob -> mob instanceof HumanMob && mob.getDistance((Mob)t) <= (float)distance && (!lineOfSight || MobUtils.HasLOS(t, (HumanMob)mob))).findFirst();
        return result.orElse(null);
    }

    public static <T extends HumanMob> boolean HasLOS(T mob, T target) {
        Line2D.Float line = new Line2D.Float(mob.x, mob.y, target.x, target.y);
        return !mob.getLevel().collides((Line2D)line, mob.getLevelCollisionFilter());
    }
}

