/*
 * Decompiled with CFR 0.152.
 */
package interactions.SettlerInteractions;

import interactions.SettlerInteractions.Conditions.ConditionHandler;
import interactions.SettlerInteractions.DialogueRegistry;
import interactions.Util.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import necesse.engine.util.GameRandom;
import necesse.entity.mobs.friendly.human.HumanMob;

public class Dialogue {
    public final String StringID;
    public final List<String> Text;
    public final List<String> Conditions;
    public byte HappinessMod = 0;
    public final List<String> Responses = new ArrayList<String>();

    public Dialogue(String id, List<String> text, List<String> conditions) {
        this.StringID = id;
        this.Conditions = conditions;
        this.Text = text.stream().map(s -> s.replace("<COMMA>", ",")).collect(Collectors.toList());
    }

    public Dialogue(String id, List<String> text, byte mod, List<String> conditions) {
        this(id, text, conditions);
        this.HappinessMod = mod;
    }

    public void AddResponse(String key) {
        this.Responses.add(key);
    }

    public String GetRandomMessage() {
        return this.Text.get(GameRandom.globalRandom.nextInt(this.Text.size()));
    }

    public <T extends HumanMob> boolean CheckConditions(T mob, T target) {
        int i;
        if (this.Conditions.isEmpty()) {
            return true;
        }
        try {
            String standard;
            String operator;
            String[] parts;
            String property;
            boolean isTargetingReceiver;
            for (i = 0; i < this.Conditions.size() && ConditionHandler.MobConditionMet((isTargetingReceiver = (property = (parts = this.Conditions.get(i).split(" "))[0]).split("_")[0].equals("target")) ? target : mob, property, operator = parts[1], standard = parts[2]); ++i) {
            }
        }
        catch (Exception e) {
            Logger.printError("Invalid condition check: " + this.Conditions.get(i) + " because " + e.getMessage() + "\n" + e.getStackTrace(), new Object[0]);
        }
        return i >= this.Conditions.size();
    }

    public <T extends HumanMob> String GetBestResponse(T mob, T receiver) {
        for (String key : this.Responses) {
            HashMap<String, Dialogue> reg = DialogueRegistry.REGISTRY.get("response");
            if (!reg.containsKey(key)) {
                Logger.printError("Unknown response " + key, new Object[0]);
                continue;
            }
            if (!DialogueRegistry.REGISTRY.get("response").get(key).CheckConditions(receiver, mob)) continue;
            return key;
        }
        return null;
    }
}

