/*
 * Decompiled with CFR 0.152.
 */
package Galva.Status;

import Galva.Leveling.LevelHolder;
import Galva.Packets.AddStatusPacket;
import Galva.Packets.GetStatusPacket;
import Galva.Packets.RemoveStatusPacket;
import Galva.Status.Attributes.Constitution;
import Galva.Status.Attributes.Dexterity;
import Galva.Status.Attributes.GalvaAttribute;
import Galva.Status.Attributes.GalvaLevel;
import Galva.Status.Attributes.Intelligence;
import Galva.Status.Attributes.Strength;
import Galva.Status.Attributes.Wisdom;
import Galva.Status.GalvaPlayers;
import java.util.ArrayList;
import necesse.engine.network.Packet;
import necesse.engine.network.client.Client;
import necesse.engine.network.server.ServerClient;
import necesse.engine.registries.BuffRegistry;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.buffs.staticBuffs.Buff;

public class GalvaPlayer
extends LevelHolder {
    public String PlayerName;
    public GalvaAttribute Constitution;
    public GalvaAttribute Dexterity;
    public GalvaAttribute Strength;
    public GalvaAttribute Intelligence;
    public GalvaAttribute Wisdom;

    public GalvaPlayer(String name) {
        this.PlayerName = name;
        this.Constitution = new Constitution();
        this.Dexterity = new Dexterity();
        this.Strength = new Strength();
        this.Intelligence = new Intelligence();
        this.Wisdom = new Wisdom();
        this.Level = new GalvaLevel();
    }

    public static void Init() {
    }

    public void LoadAttributes(PlayerMob player) {
        this.Constitution.value = this.GetActiveAttributeValue(player, this.Constitution);
        this.Strength.value = this.GetActiveAttributeValue(player, this.Strength);
        this.Dexterity.value = this.GetActiveAttributeValue(player, this.Dexterity);
        this.Intelligence.value = this.GetActiveAttributeValue(player, this.Intelligence);
        this.Wisdom.value = this.GetActiveAttributeValue(player, this.Wisdom);
        this.Level.value = this.GetActiveAttributeValue(player, this.Level);
    }

    public int GetActiveAttributeValue(PlayerMob playerMob, GalvaAttribute Attribute) {
        ArrayList activeBuffs = playerMob.buffManager.getArrayBuffs();
        Buff buff = this.GetActiveAttributeBuff(playerMob, Attribute);
        if (buff != null) {
            return Integer.parseInt(buff.getDisplayName().split("_")[1]);
        }
        if (Attribute.BuffID.equals("Level")) {
            GalvaPlayer player = GalvaPlayers.getPlayerByName(playerMob);
            player.Experience = 0;
        }
        return 1;
    }

    public Buff GetActiveAttributeBuff(PlayerMob playerMob, GalvaAttribute Attribute) {
        return this.GetActiveAttributeBuff(playerMob, Attribute.BuffID);
    }

    public Buff GetActiveAttributeBuff(PlayerMob playerMob, String BuffID) {
        ArrayList activeBuffs = playerMob.buffManager.getArrayBuffs();
        for (ActiveBuff activeBuff : activeBuffs) {
            if (!activeBuff.buff.getDisplayName().contains(BuffID)) continue;
            return activeBuff.buff;
        }
        return null;
    }

    public boolean HasAttributeBuffs(PlayerMob playerMob) {
        return this.GetActiveAttributeBuff(playerMob, "Level") != null;
    }

    public void SendDeleteAttributesPacket(Client client) {
        RemoveStatusPacket DSP = new RemoveStatusPacket(client.getPlayer().playerName);
        client.network.sendPacket((Packet)DSP);
    }

    public void SendAddAttributesPacket(Client client) {
        this.PrintStats();
        AddStatusPacket ASP = new AddStatusPacket(client.getPlayer().playerName, this.Constitution.value, this.Strength.value, this.Dexterity.value, this.Intelligence.value, this.Wisdom.value, this.Level.value);
        client.network.sendPacket((Packet)ASP);
    }

    public void SendGetAttributesPacket(ServerClient client, String Name) {
        GetStatusPacket ASP = new GetStatusPacket(Name, this.Constitution.value, this.Strength.value, this.Dexterity.value, this.Intelligence.value, this.Wisdom.value, this.Level.value, this.Experience);
        client.sendPacket((Packet)ASP);
    }

    public void GetAttributesPacket(Client client) {
        GetStatusPacket ASP = new GetStatusPacket(client.getPlayer().playerName, this.Constitution.value, this.Strength.value, this.Dexterity.value, this.Intelligence.value, this.Wisdom.value, this.Level.value, this.Experience);
        client.network.sendPacket((Packet)ASP);
    }

    public void ApplyInternalStats(PlayerMob player) {
        ActiveBuff ConBuff = new ActiveBuff(BuffRegistry.getBuff((String)this.Constitution.GetBuffValueId()), (Mob)player, 4147200.0f, null);
        ActiveBuff StrBuff = new ActiveBuff(BuffRegistry.getBuff((String)this.Strength.GetBuffValueId()), (Mob)player, 4147200.0f, null);
        ActiveBuff DexBuff = new ActiveBuff(BuffRegistry.getBuff((String)this.Dexterity.GetBuffValueId()), (Mob)player, 4147200.0f, null);
        ActiveBuff IntBuff = new ActiveBuff(BuffRegistry.getBuff((String)this.Intelligence.GetBuffValueId()), (Mob)player, 4147200.0f, null);
        ActiveBuff WisBuff = new ActiveBuff(BuffRegistry.getBuff((String)this.Wisdom.GetBuffValueId()), (Mob)player, 4147200.0f, null);
        ActiveBuff LevBuff = new ActiveBuff(BuffRegistry.getBuff((String)this.Level.GetBuffValueId()), (Mob)player, 4147200.0f, null);
        player.buffManager.addBuff(ConBuff, true);
        player.buffManager.addBuff(StrBuff, true);
        player.buffManager.addBuff(DexBuff, true);
        player.buffManager.addBuff(IntBuff, true);
        player.buffManager.addBuff(WisBuff, true);
        player.buffManager.addBuff(LevBuff, true);
    }

    public void ApplyStats(PlayerMob player, int Con, int Str, int Dex, int Int, int Wis, int Lev) {
        this.Constitution.value = Con;
        this.Strength.value = Str;
        this.Dexterity.value = Dex;
        this.Intelligence.value = Int;
        this.Wisdom.value = Wis;
        this.Level.value = Lev;
        this.ApplyInternalStats(player);
    }

    public void RemoveStats(PlayerMob player) {
        if (this.GetActiveAttributeBuff(player, this.Constitution) != null) {
            player.buffManager.removeBuff(this.GetActiveAttributeBuff(player, this.Constitution), true);
            player.buffManager.removeBuff(this.GetActiveAttributeBuff(player, this.Strength), true);
            player.buffManager.removeBuff(this.GetActiveAttributeBuff(player, this.Dexterity), true);
            player.buffManager.removeBuff(this.GetActiveAttributeBuff(player, this.Intelligence), true);
            player.buffManager.removeBuff(this.GetActiveAttributeBuff(player, this.Wisdom), true);
            player.buffManager.removeBuff(this.GetActiveAttributeBuff(player, this.Level), true);
        }
    }

    public int GetFreeStatusPoints() {
        int points = 5 + this.Level.value - this.Wisdom.value - this.Dexterity.value - this.Constitution.value - this.Strength.value - this.Intelligence.value;
        if (points < 0) {
            return 0;
        }
        return points;
    }

    public int GetTotalStatusPoints() {
        return this.GetFreeStatusPoints() + this.Wisdom.value + this.Dexterity.value + this.Constitution.value + this.Strength.value + this.Intelligence.value;
    }

    public void PrintStats() {
    }
}

