/*
 * Decompiled with CFR 0.152.
 */
package Galva.Packets;

import Galva.Galva;
import Galva.Leveling.ExpText;
import Galva.Leveling.LevelUpText;
import Galva.Menus.GalvaInventoryButton;
import Galva.Status.GalvaPlayer;
import Galva.Status.GalvaPlayers;
import necesse.engine.network.NetworkPacket;
import necesse.engine.network.Packet;
import necesse.engine.network.PacketReader;
import necesse.engine.network.PacketWriter;
import necesse.engine.network.client.Client;
import necesse.engine.network.server.Server;
import necesse.engine.network.server.ServerClient;
import necesse.engine.sound.PrimitiveSoundEmitter;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.entity.mobs.PlayerMob;
import necesse.gfx.GameResources;
import necesse.level.maps.Level;
import necesse.level.maps.hudManager.HudDrawElement;

public class AddExpPacket
extends Packet {
    public final int value;
    public final String Name;
    public final String mobLocation;

    public AddExpPacket(byte[] data) {
        super(data);
        PacketReader reader = new PacketReader((Packet)this);
        this.value = reader.getNextInt();
        this.mobLocation = reader.getNextString();
        this.Name = reader.getNextString();
    }

    public AddExpPacket(int value, String mobLocation, String Name) {
        this.value = value;
        this.mobLocation = mobLocation;
        this.Name = Name;
        PacketWriter writer = new PacketWriter((Packet)this);
        writer.putNextInt(value);
        writer.putNextString(mobLocation);
        writer.putNextString(Name);
    }

    public void processClient(NetworkPacket packet, Client client) {
        PlayerMob playerMob = client.getPlayer();
        GalvaPlayer player = GalvaPlayers.getPlayerByName(client.getPlayer());
        if (player.Level.value >= Galva.MaxLevel) {
            return;
        }
        Level level = client.getLevel();
        if (player.AddXP(this.value)) {
            try {
                LevelUpText text = new LevelUpText(playerMob.getX(), playerMob.getY());
                text.hoverTime = 1000;
                if (level != null) {
                    level.hudManager.addElement((HudDrawElement)text);
                }
                SoundManager.playSound((GameSound)GameResources.jingle, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)playerMob));
            }
            catch (Exception text) {
                // empty catch block
            }
            player.SendDeleteAttributesPacket(client);
            ++player.Level.value;
            player.SendAddAttributesPacket(client);
        } else {
            try {
                ExpText expText = new ExpText(playerMob.getX(), playerMob.getY(), this.value);
                expText.hoverTime = 1000;
                if (level != null) {
                    level.hudManager.addElement((HudDrawElement)expText);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (GalvaInventoryButton.galvaForm.IsDisplayed()) {
            GalvaInventoryButton.galvaForm.Refresh(player);
        }
        client.network.sendPacket((Packet)new AddExpPacket(this.value, this.mobLocation, this.Name));
    }

    public void processServer(NetworkPacket packet, Server server, ServerClient client) {
        GalvaPlayer player = GalvaPlayers.getPlayerByName(this.Name);
        if (player.AddXP(this.value)) {
            ++player.Level.value;
        }
    }
}

