/*
 * Decompiled with CFR 0.152.
 */
package Galva.Menus;

import Galva.Galva;
import Galva.Status.Attributes.GalvaAttribute;
import Galva.Status.GalvaPlayer;
import Galva.Status.GalvaPlayers;
import java.awt.Color;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.input.InputEvent;
import necesse.engine.network.client.Client;
import necesse.engine.window.GameWindow;
import necesse.engine.window.WindowManager;
import necesse.entity.mobs.PlayerMob;
import necesse.gfx.fairType.FairType;
import necesse.gfx.forms.Form;
import necesse.gfx.forms.FormManager;
import necesse.gfx.forms.components.FormComponent;
import necesse.gfx.forms.components.FormTextBox;
import necesse.gfx.forms.components.FormTextButton;
import necesse.gfx.gameFont.FontOptions;

public class GalvaForm
extends Form {
    FormTextButton Con;
    FormTextButton Str;
    FormTextButton Dex;
    FormTextButton Int;
    FormTextButton Wis;
    FormTextBox RP;
    FormTextBox Lev;
    FormTextBox Exp;
    public FormManager FM;
    Client client;

    public GalvaForm() {
        super("Attributes", 500, 330);
        GameWindow window = WindowManager.getWindow();
        this.setPosition(window.getHudWidth() / 2 - 250, 150);
    }

    public void handleInputEvent(InputEvent event, TickManager tickManager, PlayerMob perspective) {
        super.handleInputEvent(event, tickManager, perspective);
        if (event.isKeyboardEvent() && event.getID() == 256) {
            this.FM.removeComponent((FormComponent)this);
        }
    }

    public void Open(Client client) {
        this.client = client;
        GalvaPlayer player = GalvaPlayers.getPlayerByName(client.getPlayer().playerName);
        this.Con = new FormTextButton("Constitution (" + player.Constitution.value + ")", "Everything related to Survivability.", 10, 10, 360);
        this.Str = new FormTextButton("Strength (" + player.Strength.value + ")", "Everything related to Close Combat.", 10, 70, 360);
        this.Dex = new FormTextButton("Dexterity (" + player.Dexterity.value + ")", "Everything related to Ranged and Armor Pen.", 10, 130, 360);
        this.Int = new FormTextButton("Intelligence (" + player.Intelligence.value + ")", "Everything related to Magic and Elemental Resistance.", 10, 190, 360);
        this.Wis = new FormTextButton("Wisdom (" + player.Wisdom.value + ")", "Everything related to Summons.", 10, 250, 360);
        this.RP = new FormTextBox(new FontOptions(12), FairType.TextAlign.LEFT, Color.BLACK, 10, 310, 200);
        this.Exp = new FormTextBox(new FontOptions(12), FairType.TextAlign.LEFT, Color.BLACK, 200, 310, 200);
        this.Lev = new FormTextBox(new FontOptions(12), FairType.TextAlign.LEFT, Color.BLACK, 430, 310, 200);
        this.RP.allowTyping = false;
        this.Exp.allowTyping = false;
        this.Lev.allowTyping = false;
        this.RP.setText("Remaining Points: " + player.GetFreeStatusPoints());
        if (player.Level.value > 50) {
            this.Exp.setText("Experience: MAX/MAX");
        } else {
            this.Exp.setText("Experience: " + player.Experience + "/" + player.GetNeededExp());
        }
        this.Lev.setText("Level: " + player.Level.value);
        this.addComponent((FormComponent)this.Con);
        this.addComponent((FormComponent)this.Str);
        this.addComponent((FormComponent)this.Dex);
        this.addComponent((FormComponent)this.Int);
        this.addComponent((FormComponent)this.Wis);
        this.addComponent((FormComponent)this.RP);
        this.addComponent((FormComponent)this.Exp);
        this.addComponent((FormComponent)this.Lev);
        FormTextButton PlusCon = new FormTextButton("+", null, 380, 10, 50);
        FormTextButton MinusCon = new FormTextButton("-", null, 440, 10, 50);
        FormTextButton PlusStr = new FormTextButton("+", null, 380, 70, 50);
        FormTextButton MinusStr = new FormTextButton("-", null, 440, 70, 50);
        FormTextButton PlusDex = new FormTextButton("+", null, 380, 130, 50);
        FormTextButton MinusDex = new FormTextButton("-", null, 440, 130, 50);
        FormTextButton PlusInt = new FormTextButton("+", null, 380, 190, 50);
        FormTextButton MinusInt = new FormTextButton("-", null, 440, 190, 50);
        FormTextButton PlusWis = new FormTextButton("+", null, 380, 250, 50);
        FormTextButton MinusWis = new FormTextButton("-", null, 440, 250, 50);
        PlusCon.onClicked(e -> this.Add(player.Constitution, player));
        MinusCon.onClicked(e -> this.Subtract(player.Constitution, player));
        PlusStr.onClicked(e -> this.Add(player.Strength, player));
        MinusStr.onClicked(e -> this.Subtract(player.Strength, player));
        PlusDex.onClicked(e -> this.Add(player.Dexterity, player));
        MinusDex.onClicked(e -> this.Subtract(player.Dexterity, player));
        PlusInt.onClicked(e -> this.Add(player.Intelligence, player));
        MinusInt.onClicked(e -> this.Subtract(player.Intelligence, player));
        PlusWis.onClicked(e -> this.Add(player.Wisdom, player));
        MinusWis.onClicked(e -> this.Subtract(player.Wisdom, player));
        this.addComponent((FormComponent)PlusCon);
        this.addComponent((FormComponent)MinusCon);
        this.addComponent((FormComponent)PlusStr);
        this.addComponent((FormComponent)MinusStr);
        this.addComponent((FormComponent)PlusDex);
        this.addComponent((FormComponent)MinusDex);
        this.addComponent((FormComponent)PlusInt);
        this.addComponent((FormComponent)MinusInt);
        this.addComponent((FormComponent)PlusWis);
        this.addComponent((FormComponent)MinusWis);
    }

    public void Add(GalvaAttribute status, GalvaPlayer player) {
        if (player.GetFreeStatusPoints() > 0 && status.value < Galva.MaxStatLevel) {
            player.SendDeleteAttributesPacket(this.client);
            ++status.value;
            player.SendAddAttributesPacket(this.client);
            this.Refresh(player);
        }
    }

    public void Subtract(GalvaAttribute status, GalvaPlayer player) {
        if (status.value > 1) {
            player.SendDeleteAttributesPacket(this.client);
            --status.value;
            player.SendAddAttributesPacket(this.client);
            this.Refresh(player);
        }
    }

    public void Refresh(GalvaPlayer player) {
        this.Con.setText("Constitution (" + player.Constitution.value + ")");
        this.Str.setText("Strength (" + player.Strength.value + ")");
        this.Dex.setText("Dexterity (" + player.Dexterity.value + ")");
        this.Int.setText("Intelligence (" + player.Intelligence.value + ")");
        this.Wis.setText("Wisdom (" + player.Wisdom.value + ")");
        this.RP.setText("Remaining Points: " + player.GetFreeStatusPoints());
        if (player.Level.value == Galva.MaxLevel) {
            this.Exp.setText("Experience: MAX/MAX");
        } else {
            this.Exp.setText("Experience: " + player.Experience + "/" + player.GetNeededExp());
        }
        this.Lev.setText("Level: " + player.Level.value);
    }

    public boolean IsDisplayed() {
        return this.FM.hasComponent((FormComponent)this);
    }
}

