/*
 * Decompiled with CFR 0.152.
 */
package Galva.Leveling;

import Galva.Galva;
import Galva.Leveling.BiomeLevels;
import Galva.Packets.AddExpPacket;
import Galva.Status.GalvaPlayer;
import Galva.Status.GalvaPlayers;
import java.util.HashSet;
import necesse.engine.modLoader.annotations.ModMethodPatch;
import necesse.engine.network.Packet;
import necesse.engine.network.server.ServerClient;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import net.bytebuddy.asm.Advice;

@ModMethodPatch(target=Mob.class, name="onDeath", arguments={Attacker.class, HashSet.class})
public class ExpDrop {
    @Advice.OnMethodExit
    public static void onExit(@Advice.This Mob mob, @Advice.Argument(value=1) HashSet<Attacker> attackers) {
        if (mob.getLevel() == null) {
            return;
        }
        if (mob.isHostile) {
            for (Attacker attacker : attackers) {
                if (!(attacker instanceof PlayerMob)) continue;
                PlayerMob playerMob = (PlayerMob)attacker;
                ServerClient serverClient = playerMob.getServerClient();
                GalvaPlayer player = GalvaPlayers.getPlayerByName(playerMob);
                if (player.Level.value == Galva.MaxLevel) {
                    return;
                }
                int xpAmount = ExpDrop.GetXpAmount(mob, player);
                serverClient.sendPacket((Packet)new AddExpPacket(xpAmount, mob.getLevel().getStringID(), player.PlayerName));
            }
        }
    }

    public static int GetXpAmount(Mob mob, GalvaPlayer player) {
        int mobExp = mob.getMaxHealth() / 2 + mob.getArmorFlat() * 2 + Math.round(mob.getSpeed()) * 2;
        float multiplier = BiomeLevels.GetMultiplier(mob.getLevel().getBiome(mob.getTileX(), mob.getTileY())) / (float)player.Level.value;
        return Math.round((float)mobExp * multiplier);
    }
}

