/*
 * Decompiled with CFR 0.152.
 */
package Galva;

import Galva.Commands.LevelCommand;
import Galva.Packets.AddExpPacket;
import Galva.Packets.AddStatusPacket;
import Galva.Packets.GetStatusPacket;
import Galva.Packets.RemoveStatusPacket;
import Galva.Status.Attributes.Constitution;
import Galva.Status.Attributes.Dexterity;
import Galva.Status.Attributes.GalvaLevel;
import Galva.Status.Attributes.Intelligence;
import Galva.Status.Attributes.Strength;
import Galva.Status.Attributes.Wisdom;
import Galva.Status.GalvaPlayer;
import necesse.engine.commands.ChatCommand;
import necesse.engine.commands.CommandsManager;
import necesse.engine.modLoader.annotations.ModEntry;
import necesse.engine.registries.BuffRegistry;
import necesse.engine.registries.PacketRegistry;
import necesse.entity.mobs.buffs.staticBuffs.Buff;

@ModEntry
public class Galva {
    public static int MaxLevel = 100;
    public static int MaxStatLevel = 41;
    public static int BaseStatLevel = 1;

    public void init() {
        this.InitItems();
        this.InitBuffs();
        this.InitPackets();
        this.InitCommands();
    }

    public void InitItems() {
    }

    public void InitBuffs() {
        int i;
        for (i = 1; i < MaxStatLevel + 1; ++i) {
            Constitution Con = new Constitution(i);
            Dexterity Dex = new Dexterity(i);
            Strength Str = new Strength(i);
            Intelligence Int = new Intelligence(i);
            Wisdom Wis = new Wisdom(i);
            BuffRegistry.registerBuff((String)("Constitution_" + i), (Buff)Con.buff);
            BuffRegistry.registerBuff((String)("Dexterity_" + i), (Buff)Dex.buff);
            BuffRegistry.registerBuff((String)("Strength_" + i), (Buff)Str.buff);
            BuffRegistry.registerBuff((String)("Intelligence_" + i), (Buff)Int.buff);
            BuffRegistry.registerBuff((String)("Wisdom_" + i), (Buff)Wis.buff);
        }
        for (i = 1; i < MaxLevel + 1; ++i) {
            GalvaLevel Lev = new GalvaLevel(i);
            BuffRegistry.registerBuff((String)("Level_" + i), (Buff)Lev.buff);
        }
        GalvaPlayer.Init();
    }

    public void InitPackets() {
        PacketRegistry.registerPacket(AddStatusPacket.class);
        PacketRegistry.registerPacket(RemoveStatusPacket.class);
        PacketRegistry.registerPacket(AddExpPacket.class);
        PacketRegistry.registerPacket(GetStatusPacket.class);
    }

    public void InitCommands() {
        CommandsManager.registerServerCommand((ChatCommand)new LevelCommand());
    }

    public void initResources() {
    }

    public void postInit() {
    }
}

