/*
 * Decompiled with CFR 0.152.
 */
package Galva.Commands;

import Galva.Status.GalvaPlayer;
import Galva.Status.GalvaPlayers;
import necesse.engine.commands.CmdParameter;
import necesse.engine.commands.CommandLog;
import necesse.engine.commands.ModularChatCommand;
import necesse.engine.commands.PermissionLevel;
import necesse.engine.commands.parameterHandlers.IntParameterHandler;
import necesse.engine.commands.parameterHandlers.ParameterHandler;
import necesse.engine.commands.parameterHandlers.StoredPlayerParameterHandler;
import necesse.engine.network.client.Client;
import necesse.engine.network.server.Server;
import necesse.engine.network.server.ServerClient;

public class LevelCommand
extends ModularChatCommand {
    public LevelCommand() {
        super("setLevel", "Command to set player level", PermissionLevel.ADMIN, false, new CmdParameter[]{new CmdParameter("player", (ParameterHandler)new StoredPlayerParameterHandler(), false, new CmdParameter[0]), new CmdParameter("level", (ParameterHandler)new IntParameterHandler(), false, new CmdParameter[0])});
    }

    public void runModular(Client client, Server server, ServerClient serverClient, Object[] args, String[] errors, CommandLog commandLog) {
        try {
            commandLog.add(args.toString());
            StoredPlayerParameterHandler.StoredPlayer storedPlayer = (StoredPlayerParameterHandler.StoredPlayer)args[0];
            Integer level = (Integer)args[1];
            if (storedPlayer == null) {
                commandLog.add("No given player");
                return;
            }
            if (!GalvaPlayers.playerExists(storedPlayer.name)) {
                commandLog.add("No player matching name");
                return;
            }
            GalvaPlayer player = GalvaPlayers.getPlayerByName(storedPlayer.name);
            player.Level.value = level;
            player.SendGetAttributesPacket(serverClient, storedPlayer.name);
        }
        catch (Exception e) {
            commandLog.add(e.getMessage());
        }
    }
}

