/*
 * Decompiled with CFR 0.152.
 */
package moonlight;

import moonlight.MoonlightProjectile;
import necesse.engine.localization.Localization;
import necesse.engine.network.gameNetworkData.GNDItemMap;
import necesse.engine.util.GameRandom;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.BuffModifiers;
import necesse.entity.mobs.itemAttacker.ItemAttackSlot;
import necesse.entity.mobs.itemAttacker.ItemAttackerMob;
import necesse.entity.projectile.Projectile;
import necesse.entity.projectile.modifiers.ProjectileModifier;
import necesse.entity.projectile.modifiers.ResilienceOnHitProjectileModifier;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.inventory.InventoryItem;
import necesse.inventory.enchants.ToolItemModifiers;
import necesse.inventory.item.Item;
import necesse.inventory.item.toolItem.swordToolItem.SwordToolItem;
import necesse.inventory.lootTable.presets.CloseRangeWeaponsLootTable;
import necesse.level.maps.Level;

public class MoonlightGreatsword
extends SwordToolItem {
    public MoonlightGreatsword() {
        super(2300, CloseRangeWeaponsLootTable.closeRangeWeapons);
        this.rarity = Item.Rarity.LEGENDARY;
        this.attackAnimTime.setBaseValue(350);
        this.attackDamage.setBaseValue(88.0f).setUpgradedValue(1.0f, 110.0f);
        this.attackRange.setBaseValue(110);
        this.knockback.setBaseValue(75);
        this.resilienceGain.setBaseValue(1.0f);
    }

    public InventoryItem onAttack(Level level, int x, int y, ItemAttackerMob attackerMob, int attackHeight, InventoryItem item, ItemAttackSlot slot, int animAttack, int seed, GNDItemMap mapContent) {
        item = super.onAttack(level, x, y, attackerMob, attackHeight, item, slot, animAttack, seed, mapContent);
        float rangeMod = 7.0f;
        float velocity = 140.0f;
        float finalVelocity = Math.round(((Float)this.getEnchantment(item).applyModifierLimited(ToolItemModifiers.VELOCITY, (Object)((Float)ToolItemModifiers.VELOCITY.defaultBuffManagerValue))).floatValue() * velocity * ((Float)attackerMob.buffManager.getModifier(BuffModifiers.PROJECTILE_VELOCITY)).floatValue());
        MoonlightProjectile moonlightProjectile = new MoonlightProjectile(level, attackerMob.x, attackerMob.y, x, y, finalVelocity, (int)((float)this.getAttackRange(item) * rangeMod), this.getAttackDamage(item), (Mob)attackerMob);
        GameRandom random = new GameRandom((long)seed);
        moonlightProjectile.setModifier((ProjectileModifier)new ResilienceOnHitProjectileModifier(this.getResilienceGain(item) / 2.0f));
        moonlightProjectile.resetUniqueID(new GameRandom((long)seed));
        attackerMob.addAndSendAttackerProjectile((Projectile)moonlightProjectile, 20);
        return item;
    }

    public ListGameTooltips getTooltips(InventoryItem item, PlayerMob perspective) {
        ListGameTooltips tooltips = super.getTooltips(item, perspective, null);
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"moonlightgs"));
        return tooltips;
    }
}

