/*
 * Decompiled with CFR 0.152.
 */
package theholyrailmod.theholyrail;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.function.Predicate;
import necesse.engine.GameTileRange;
import necesse.engine.network.Packet;
import necesse.engine.network.PacketReader;
import necesse.engine.network.PacketWriter;
import necesse.engine.network.packet.PacketObjectEntity;
import necesse.engine.network.packet.PacketOpenContainer;
import necesse.engine.network.server.ServerClient;
import necesse.engine.registries.ContainerRegistry;
import necesse.engine.save.LoadData;
import necesse.engine.save.SaveData;
import necesse.engine.util.GameRandom;
import necesse.entity.objectEntity.ObjectEntity;
import necesse.entity.objectEntity.interfaces.OEInventory;
import necesse.inventory.Inventory;
import necesse.inventory.InventoryItem;
import necesse.inventory.InventoryRange;
import necesse.level.gameObject.GameObject;
import necesse.level.maps.Level;
import necesse.level.maps.multiTile.MultiTile;
import theholyrailmod.theholyrail.ChestMinecartMob;

public class StationTrackObjectEntity
extends ObjectEntity {
    private final long TRANSFER_ITEM_COOLDOWN = 75L;
    private static int nearbyInventoryRange = 3;
    private LinkedHashSet<Inventory> nearbyInventories = new LinkedHashSet();
    private boolean isTransferringItems;
    private long lastItemTransferTime = -1L;
    public final GameTileRange range;
    public boolean isPowered;
    private long MAX_STATION_WAIT_TIME;
    private boolean waitSeconds;
    private boolean waitEmpty;
    private boolean waitFull;
    private boolean roleManual = true;
    private boolean roleLoad;
    private boolean roleUnload;

    public StationTrackObjectEntity(Level level, int x, int y) {
        super(level, "stationtrack", x, y);
        this.shouldSave = true;
        this.waitSeconds = true;
        this.roleUnload = false;
        this.roleLoad = false;
        this.isPowered = false;
        this.waitFull = false;
        this.waitEmpty = false;
        this.isTransferringItems = false;
        this.MAX_STATION_WAIT_TIME = 5200L;
        GameObject gObj = this.getLevel().getObject(this.tileX, this.tileY);
        MultiTile mt = gObj.getMultiTile(this.getLevel(), 0, this.tileX, this.tileY);
        Rectangle rect = mt.getTileRectangle(0, 0);
        this.range = new GameTileRange(nearbyInventoryRange, rect);
        for (InventoryRange inventoryRange : this.findNearbyInventories(level, this.tileX, this.tileY, this.range, OEInventory::canUseForNearbyCrafting)) {
            this.nearbyInventories.add(inventoryRange.inventory);
        }
    }

    public void openContainer(int CONTAINER, ServerClient client) {
        ContainerRegistry.openAndSendContainer((ServerClient)client, (PacketOpenContainer)PacketOpenContainer.ObjectEntity((int)CONTAINER, (ObjectEntity)this));
    }

    public long getMaxStationWaitTime() {
        return this.MAX_STATION_WAIT_TIME;
    }

    public void setMaxStationWaitTime(long time) {
        this.MAX_STATION_WAIT_TIME = time;
    }

    public boolean getWaitSeconds() {
        return this.waitSeconds;
    }

    public void setWaitSeconds(boolean wait) {
        this.waitSeconds = wait;
    }

    public boolean getWaitEmpty() {
        return this.waitEmpty;
    }

    public void setWaitEmpty(boolean wait) {
        this.waitEmpty = wait;
    }

    public boolean getWaitFull() {
        return this.waitFull;
    }

    public void setWaitFull(boolean wait) {
        this.waitFull = wait;
    }

    public boolean getRoleManual() {
        return this.roleManual;
    }

    public void setRoleManual(boolean role) {
        this.roleManual = role;
    }

    public boolean getRoleLoad() {
        return this.roleLoad;
    }

    public void setRoleLoad(boolean role) {
        this.roleLoad = role;
    }

    public boolean getRoleUnload() {
        return this.roleUnload;
    }

    public void setRoleUnload(boolean role) {
        this.roleUnload = role;
    }

    public boolean getIsTransferringItems() {
        return this.isTransferringItems;
    }

    public void setIsTransferringItems(boolean transferring) {
        this.isTransferringItems = transferring;
    }

    public void sendUpdatePacket() {
        if (this.getLevel().isClient()) {
            this.getLevel().getClient().network.sendPacket((Packet)new PacketObjectEntity((ObjectEntity)this));
        }
    }

    public LinkedHashSet<Inventory> getNearbyInventories() {
        return this.nearbyInventories;
    }

    public void recheckNearbyInventories() {
        this.nearbyInventories.clear();
        for (InventoryRange inventoryRange : this.findNearbyInventories(this.getLevel(), this.tileX, this.tileY, this.range, OEInventory::canUseForNearbyCrafting)) {
            this.nearbyInventories.add(inventoryRange.inventory);
        }
    }

    public ArrayList<InventoryRange> findNearbyInventories(Level level, int centerTileX, int centerTileY, GameTileRange range, Predicate<OEInventory> filter) {
        if (level == null) {
            return new ArrayList<InventoryRange>();
        }
        ArrayList<InventoryRange> targets = new ArrayList<InventoryRange>();
        for (Point tile : range.getValidTiles(centerTileX, centerTileY)) {
            ObjectEntity ent = level.entityManager.getObjectEntity(tile.x, tile.y);
            if (!(ent instanceof OEInventory) || filter != null && !filter.test((OEInventory)ent)) continue;
            Inventory inventory = ((OEInventory)ent).getInventory();
            if (targets.stream().anyMatch(i -> i.inventory == inventory)) continue;
            targets.add(new InventoryRange(inventory));
        }
        return targets;
    }

    public void transferItemsToMinecart(ChestMinecartMob mob) {
        block7: {
            if (!this.getIsTransferringItems()) {
                this.setIsTransferringItems(true);
                this.recheckNearbyInventories();
                if (this.lastItemTransferTime == -1L) {
                    this.lastItemTransferTime = this.getWorldEntity().getTime();
                }
                GameRandom random = new GameRandom((long)GameRandom.globalRandom.nextInt());
                ArrayList<Inventory> invArray = new ArrayList<Inventory>(this.getNearbyInventories());
                Inventory randomInv = invArray.get(random.getIntBetween(0, invArray.size() - 1));
                int invSize = randomInv.getSize();
                for (int i = 0; i < invSize; ++i) {
                    InventoryItem toItem;
                    int j;
                    if (randomInv.isSlotClear(i)) continue;
                    boolean hasItem = false;
                    InventoryItem fromItem = randomInv.getItem(i);
                    for (j = 0; j < mob.getInventory().getSize(); ++j) {
                        if (mob.getInventory().isSlotClear(j) || mob.getInventory().getItem(j).getItemDisplayName() != randomInv.getItem(i).getItemDisplayName() || mob.getInventory().canAddItem(this.getLevel(), null, fromItem, j, j, "chestminecartcheckstack") <= 0) continue;
                        hasItem = true;
                        toItem = mob.getInventory().getItem(j);
                        fromItem.setAmount(fromItem.getAmount() - 1);
                        toItem.setAmount(toItem.getAmount() + 1);
                        randomInv.setItem(i, fromItem);
                        mob.getInventory().setItem(j, toItem);
                        randomInv.markDirty(i);
                        mob.getInventory().markDirty(j);
                        break;
                    }
                    if (hasItem) break;
                    for (j = 0; j < mob.getInventory().getSize(); ++j) {
                        if (!mob.getInventory().isSlotClear(j)) continue;
                        toItem = new InventoryItem(fromItem.item);
                        fromItem.setAmount(fromItem.getAmount() - 1);
                        toItem.setAmount(1);
                        randomInv.setItem(i, fromItem);
                        mob.getInventory().setItem(j, toItem);
                        randomInv.markDirty(i);
                        mob.getInventory().markDirty(j);
                        break block7;
                    }
                    break;
                }
            } else if (this.lastItemTransferTime != -1L && this.getWorldEntity().getTime() - this.lastItemTransferTime > 75L) {
                this.lastItemTransferTime = -1L;
                mob.getAndSetFilledInventorySlots();
                this.setIsTransferringItems(false);
            }
        }
    }

    public void transferItemsFromMinecart(ChestMinecartMob mob) {
        if (!this.getIsTransferringItems()) {
            this.setIsTransferringItems(true);
            this.recheckNearbyInventories();
            if (this.lastItemTransferTime == -1L) {
                this.lastItemTransferTime = this.getWorldEntity().getTime();
            }
            InventoryItem item = null;
            int mobItemInSlot = -1;
            for (int i = 0; i < mob.getInventory().getSize(); ++i) {
                if (mob.getInventory().isSlotClear(i)) continue;
                item = mob.getInventory().getItem(i);
                mobItemInSlot = i;
                break;
            }
            if (item != null) {
                for (Inventory inv : this.getNearbyInventories()) {
                    boolean addedItem = false;
                    if (inv.canAddItem(this.getLevel(), null, item, 0, inv.getSize(), "unloadchestminecart") > 0) {
                        int i;
                        boolean hasItem = false;
                        int itemInSlot = -1;
                        for (i = 0; i < inv.getSize(); ++i) {
                            if (inv.isSlotClear(i) || inv.getItem(i).getItemDisplayName() != item.getItemDisplayName()) continue;
                            hasItem = true;
                            itemInSlot = i;
                            break;
                        }
                        if (hasItem) {
                            InventoryItem toItem = inv.getItem(itemInSlot);
                            toItem.setAmount(toItem.getAmount() + 1);
                            item.setAmount(item.getAmount() - 1);
                            inv.setItem(itemInSlot, toItem);
                            mob.getInventory().setItem(mobItemInSlot, item);
                            inv.markDirty(itemInSlot);
                            mob.getInventory().markDirty(mobItemInSlot);
                            addedItem = true;
                        } else {
                            for (i = 0; i < inv.getSize(); ++i) {
                                if (!inv.isSlotClear(i)) continue;
                                InventoryItem toItem = new InventoryItem(item.item);
                                item.setAmount(item.getAmount() - 1);
                                toItem.setAmount(1);
                                inv.setItem(i, toItem);
                                mob.getInventory().setItem(mobItemInSlot, item);
                                inv.markDirty(itemInSlot);
                                mob.getInventory().markDirty(mobItemInSlot);
                                addedItem = true;
                                break;
                            }
                        }
                    }
                    if (!addedItem) continue;
                    break;
                }
            }
        } else if (this.lastItemTransferTime != -1L && this.getWorldEntity().getTime() - this.lastItemTransferTime > 75L) {
            this.lastItemTransferTime = -1L;
            mob.getAndSetFilledInventorySlots();
            this.setIsTransferringItems(false);
        }
    }

    public void addSaveData(SaveData save) {
        super.addSaveData(save);
        save.addLong("station_wait_time", this.getMaxStationWaitTime());
        save.addBoolean("wait_seconds", this.waitSeconds);
        save.addBoolean("wait_empty", this.waitEmpty);
        save.addBoolean("wait_full", this.waitFull);
        save.addBoolean("role_manual", this.roleManual);
        save.addBoolean("role_load", this.roleLoad);
        save.addBoolean("role_unload", this.roleUnload);
    }

    public void applyLoadData(LoadData save) {
        super.applyLoadData(save);
        this.setMaxStationWaitTime(save.getLong("station_wait_time", 5200L));
        this.setWaitSeconds(save.getBoolean("wait_seconds", true));
        this.setWaitEmpty(save.getBoolean("wait_empty", false));
        this.setWaitFull(save.getBoolean("wait_full", false));
        this.setRoleManual(save.getBoolean("role_manual", false));
        this.setRoleLoad(save.getBoolean("role_load", false));
        this.setRoleUnload(save.getBoolean("role_unload", false));
    }

    public void setupContentPacket(PacketWriter writer) {
        super.setupContentPacket(writer);
        writer.putNextLong(this.getMaxStationWaitTime());
        writer.putNextBoolean(this.getWaitSeconds());
        writer.putNextBoolean(this.getWaitEmpty());
        writer.putNextBoolean(this.getWaitFull());
        writer.putNextBoolean(this.getRoleManual());
        writer.putNextBoolean(this.getRoleLoad());
        writer.putNextBoolean(this.getRoleUnload());
    }

    public void applyContentPacket(PacketReader reader) {
        super.applyContentPacket(reader);
        this.setMaxStationWaitTime(reader.getNextLong());
        this.setWaitSeconds(reader.getNextBoolean());
        this.setWaitEmpty(reader.getNextBoolean());
        this.setWaitFull(reader.getNextBoolean());
        this.setRoleManual(reader.getNextBoolean());
        this.setRoleLoad(reader.getNextBoolean());
        this.setRoleUnload(reader.getNextBoolean());
    }
}

