/*
 * Decompiled with CFR 0.152.
 */
package theholyrailmod.theholyrail;

import java.awt.Point;
import java.util.List;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.network.PacketReader;
import necesse.engine.network.PacketWriter;
import necesse.engine.registries.MobRegistry;
import necesse.engine.save.LoadData;
import necesse.engine.save.SaveData;
import necesse.engine.sound.SoundPlayer;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.MobDrawable;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.summon.MinecartLinePos;
import necesse.entity.mobs.summon.MinecartLines;
import necesse.entity.mobs.summon.summonFollowingMob.mountFollowingMob.MinecartMountMob;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.DrawOptions;
import necesse.gfx.drawOptions.texture.TextureDrawOptionsEnd;
import necesse.gfx.drawables.OrderableDrawables;
import necesse.gfx.gameTexture.GameTexture;
import necesse.level.gameObject.GameObject;
import necesse.level.gameObject.MinecartTrackObject;
import necesse.level.maps.Level;
import necesse.level.maps.light.GameLight;

public class RailRunnerMob
extends MinecartMountMob {
    public static GameTexture texture;
    public float collisionMovementBuffer;
    public Point collisionMovementLastPos;
    public float railRunnerSpeed;
    public int railRunnerDir;
    protected SoundPlayer movingSound;
    protected SoundPlayer breakingSound;
    protected float breakParticleBuffer;
    protected boolean breakParticleAlternate;
    public final float MAX_SPEED = 265.0f;
    public final float BOOST_SPEED = 1325.0f;

    public RailRunnerMob() {
        this.setSpeed(265.0f);
        this.setFriction(2.65f);
        this.accelerationMod = 0.4f;
    }

    public void addSaveData(SaveData save) {
        super.addSaveData(save);
        save.addInt("railRunnerDir", this.railRunnerDir);
        save.addFloat("railRunnerSpeed", this.railRunnerSpeed);
    }

    public void applyLoadData(LoadData save) {
        super.applyLoadData(save);
        this.railRunnerDir = save.getInt("railRunnerDir", this.railRunnerDir);
        this.railRunnerSpeed = save.getFloat("railRunnerSpeed", this.railRunnerSpeed);
    }

    public void setupMovementPacket(PacketWriter writer) {
        super.setupMovementPacket(writer);
        writer.putNextFloat(this.railRunnerSpeed);
        writer.putNextMaxValue(this.railRunnerDir, 3);
    }

    public void applyMovementPacket(PacketReader reader, boolean isDirect) {
        super.applyMovementPacket(reader, isDirect);
        this.railRunnerSpeed = reader.getNextFloat();
        this.railRunnerDir = reader.getNextMaxValue(3);
    }

    public void addDrawables(List<MobDrawable> list, OrderableDrawables tileList, OrderableDrawables topList, Level level, int x, int y, TickManager tickManager, GameCamera camera, PlayerMob perspective) {
        super.addDrawables(list, tileList, topList, level, x, y, tickManager, camera, perspective);
        GameLight light = level.getLightLevel(this.getTileX(), this.getTileY());
        int drawX = camera.getDrawX(x) - 32;
        int drawY = camera.getDrawY(y) - 51;
        Point sprite = this.getAnimSprite(x, y, this.getDir());
        drawY += this.getBobbing(x, y);
        TextureDrawOptionsEnd behind = texture.initDraw().sprite(sprite.x, sprite.y, 64).light(light).pos(drawX, drawY += this.getLevel().getTile(this.getTileX(), this.getTileY()).getMobSinkingAmount((Mob)this));
        TextureDrawOptionsEnd drawOptions = texture.initDraw().sprite(sprite.x, sprite.y, 64).light(light).pos(drawX, drawY);
        list.add(new MobDrawable((DrawOptions)drawOptions, (DrawOptions)behind){
            final /* synthetic */ DrawOptions val$drawOptions;
            final /* synthetic */ DrawOptions val$behind;
            {
                this.val$drawOptions = drawOptions;
                this.val$behind = drawOptions2;
            }

            public void draw(TickManager tickManager) {
                this.val$drawOptions.draw();
            }

            public void drawBehindRider(TickManager tickManager) {
                this.val$behind.draw();
            }
        });
        this.addShadowDrawables(tileList, level, x, y, light, camera);
    }

    public static void drawPlacePreview(Level level, int levelX, int levelY, int dir, GameCamera camera) {
        Mob mob = MobRegistry.getMob((String)"railrunnermob", (Level)level);
        if (mob != null) {
            mob.setPos((float)levelX, (float)levelY, true);
            int tileX = mob.getTileX();
            int tileY = mob.getTileY();
            GameObject object = level.getObject(tileX, tileY);
            if (object instanceof MinecartTrackObject) {
                MinecartTrackObject trackObject = (MinecartTrackObject)object;
                float moveX = 0.0f;
                float moveY = 0.0f;
                if (dir == 0) {
                    moveY = -1.0f;
                } else if (dir == 1) {
                    moveX = 1.0f;
                } else if (dir == 2) {
                    moveY = 1.0f;
                } else {
                    moveX = -1.0f;
                }
                MinecartLines lines = trackObject.getMinecartLines(level, tileX, tileY, moveX, moveY, false);
                MinecartLinePos pos = lines.getMinecartPos((float)levelX, (float)levelY, dir);
                if (pos != null) {
                    int drawX = camera.getDrawX(pos.x) - 32;
                    int drawY = camera.getDrawY(pos.y) - 47;
                    Point sprite = mob.getAnimSprite((int)pos.x, (int)pos.y, pos.dir);
                    drawY += mob.getBobbing((int)pos.x, (int)pos.y);
                    texture.initDraw().sprite(sprite.x, sprite.y, 64).alpha(0.5f).draw(drawX, drawY += level.getTile((int)pos.x / 32, (int)pos.y / 32).getMobSinkingAmount(mob));
                    return;
                }
            }
        }
        int drawX = camera.getDrawX(levelX) - 32;
        int drawY = camera.getDrawY(levelY) - 47;
        texture.initDraw().sprite(0, dir, 64).alpha(0.5f).draw(drawX, drawY += level.getLevelTile(levelX / 32, levelY / 32).getLiquidBobbing());
    }

    public static int registerRailRunnerMob() {
        return MobRegistry.registerMob((String)"railrunnermob", RailRunnerMob.class, (boolean)false);
    }
}

