/*
 * Decompiled with CFR 0.152.
 */
package theholyrailmod.theholyrail;

import java.util.List;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.registries.ObjectRegistry;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.objectEntity.ObjectEntity;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.DrawOptionsList;
import necesse.gfx.drawOptions.texture.TextureDrawOptions;
import necesse.gfx.drawOptions.texture.TextureDrawOptionsEnd;
import necesse.gfx.drawables.LevelSortedDrawable;
import necesse.gfx.drawables.OrderableDrawables;
import necesse.gfx.gameTexture.GameTexture;
import necesse.level.gameObject.GameObject;
import necesse.level.maps.Level;
import necesse.level.maps.light.GameLight;
import theholyrailmod.theholyrail.CustomTrackObject;
import theholyrailmod.theholyrail.PoweredRailObjectEntity;

public class PoweredRailObject
extends CustomTrackObject {
    protected int objectId;
    public GameTexture unpoweredTexture;
    public GameTexture poweredTexture;

    public PoweredRailObject() {
        this.setItemCategory(new String[]{"wiring"});
        this.stackSize = 50;
        this.showsWire = true;
        this.isLightTransparent = false;
        this.roomProperties.add("lights");
    }

    public void loadTextures() {
        super.loadTextures();
        this.unpoweredTexture = GameTexture.fromFile((String)"objects/poweredrail_unpowered");
        this.poweredTexture = GameTexture.fromFile((String)"objects/poweredrail");
    }

    public ObjectEntity getNewObjectEntity(Level level, int x, int y) {
        return new PoweredRailObjectEntity(level, x, y);
    }

    public int getLightLevel(Level level, int layerID, int x, int y) {
        return this.isPowered(level, x, y) ? 50 : 0;
    }

    public void onWireUpdate(Level level, int layerID, int x, int y, int wireID, boolean active) {
        ObjectEntity ent;
        level.lightManager.updateStaticLight(x, y);
        if (this.isPowered(level, x, y)) {
            this.roomProperties.add("lights");
        } else {
            this.roomProperties.remove("lights");
        }
        if (active && (ent = level.entityManager.getObjectEntity(x, y)) != null) {
            ((PoweredRailObjectEntity)ent).isPowered = true;
        }
    }

    public boolean isPowered(Level level, int x, int y) {
        return level.wireManager.isWireActiveAny(x, y);
    }

    public void addDrawables(List<LevelSortedDrawable> list, OrderableDrawables tileList, Level level, int tileX, int tileY, TickManager tickManager, GameCamera camera, PlayerMob perspective) {
        byte rotation = level.getObjectRotation(tileX, tileY);
        GameLight light = level.getLightLevel(tileX, tileY);
        GameTexture bridgeTexture = this.bridgeTexture;
        GameTexture supportTexture = this.supportTexture;
        int drawX = camera.getTileDrawX(tileX);
        int drawY = camera.getTileDrawY(tileY);
        DrawOptionsList options = new DrawOptionsList();
        CustomTrackObject.TrackSprite sprite = this.getCustomSprite(level, tileX, tileY, rotation);
        if (level.isLiquidTile(tileX, tileY) || level.isShore(tileX, tileY)) {
            if ((level.isLiquidTile(tileX, tileY + 1) || level.isShore(tileX, tileY + 1)) && (!sprite.connectedDown || sprite.connectedLeft || sprite.connectedRight)) {
                TextureDrawOptionsEnd bridgeOptions = bridgeTexture.initDraw().sprite(sprite.x, sprite.y, 32).light(light).pos(drawX, drawY + 8);
                tileList.add(-100, arg_0 -> PoweredRailObject.lambda$addDrawables$0((TextureDrawOptions)bridgeOptions, arg_0));
            }
            options.add((Object)supportTexture.initDraw().sprite(sprite.x, sprite.y, 32).light(light).pos(drawX, drawY));
        }
        if (this.isPowered(level, tileX, tileY)) {
            options.add((Object)this.poweredTexture.initDraw().sprite(sprite.x, sprite.y, 32).light(light).pos(drawX, drawY));
        } else {
            options.add((Object)this.unpoweredTexture.initDraw().sprite(sprite.x, sprite.y, 32).light(light).pos(drawX, drawY));
        }
        if (sprite.goingUp && !sprite.connectedUp) {
            options.add((Object)this.endingTexture.initDraw().sprite(0, 0, 32).light(light).pos(drawX, drawY));
        }
        if (sprite.goingRight && !sprite.connectedRight) {
            options.add((Object)this.endingTexture.initDraw().sprite(0, 1, 32).light(light).pos(drawX, drawY));
        }
        if (sprite.goingDown && !sprite.connectedDown) {
            options.add((Object)this.endingTexture.initDraw().sprite(0, 2, 32).light(light).pos(drawX, drawY));
        }
        if (sprite.goingLeft && !sprite.connectedLeft) {
            options.add((Object)this.endingTexture.initDraw().sprite(0, 3, 32).light(light).pos(drawX, drawY));
        }
        tileList.add(tm -> options.draw());
    }

    public void drawPreview(Level level, int tileX, int tileY, int rotation, float alpha, PlayerMob player, GameCamera camera) {
        int drawX = camera.getTileDrawX(tileX);
        int drawY = camera.getTileDrawY(tileY);
        GameTexture bridgeTexture = this.bridgeTexture;
        GameTexture supportTexture = this.supportTexture;
        CustomTrackObject.TrackSprite sprite = this.getCustomSprite(level, tileX, tileY, rotation);
        if (level.isLiquidTile(tileX, tileY) || level.isShore(tileX, tileY)) {
            if ((level.isLiquidTile(tileX, tileY + 1) || level.isShore(tileX, tileY + 1)) && (!sprite.connectedDown || sprite.connectedLeft || sprite.connectedRight)) {
                bridgeTexture.initDraw().sprite(sprite.x, sprite.y, 32).alpha(alpha).draw(drawX, drawY + 8);
            }
            supportTexture.initDraw().sprite(sprite.x, sprite.y, 32).alpha(alpha).draw(drawX, drawY);
        }
        if (this.isPowered(level, tileX, tileY)) {
            this.poweredTexture.initDraw().sprite(sprite.x, sprite.y, 32).alpha(alpha).draw(drawX, drawY);
        } else {
            this.unpoweredTexture.initDraw().sprite(sprite.x, sprite.y, 32).alpha(alpha).draw(drawX, drawY);
        }
        if (sprite.goingUp && !sprite.connectedUp) {
            this.endingTexture.initDraw().sprite(0, 0, 32).alpha(alpha).draw(drawX, drawY);
        }
        if (sprite.goingRight && !sprite.connectedRight) {
            this.endingTexture.initDraw().sprite(0, 1, 32).alpha(alpha).draw(drawX, drawY);
        }
        if (sprite.goingDown && !sprite.connectedDown) {
            this.endingTexture.initDraw().sprite(0, 2, 32).alpha(alpha).draw(drawX, drawY);
        }
        if (sprite.goingLeft && !sprite.connectedLeft) {
            this.endingTexture.initDraw().sprite(0, 3, 32).alpha(alpha).draw(drawX, drawY);
        }
    }

    public static int registerPoweredRail() {
        PoweredRailObject prObj = new PoweredRailObject();
        prObj.objectId = ObjectRegistry.registerObject((String)"poweredrail", (GameObject)prObj, (float)10.0f, (boolean)true);
        return prObj.objectId;
    }

    private static /* synthetic */ void lambda$addDrawables$0(TextureDrawOptions bridgeOptions, TickManager tm) {
        bridgeOptions.draw();
    }
}

