/*
 * Decompiled with CFR 0.152.
 */
package theholyrailmod.theholyrail;

import java.util.Arrays;
import necesse.entity.mobs.summon.MinecartLine;
import necesse.entity.mobs.summon.MinecartLines;
import necesse.level.gameObject.MinecartTrackObject;
import necesse.level.maps.Level;

public class CustomTrackObject
extends MinecartTrackObject {
    private String[] railIds = new String[]{"minecarttrack", "poweredrail", "stationtrack"};

    public TrackSprite getCustomSprite(Level level, int tileX, int tileY, int rotation) {
        TrackSprite out = new TrackSprite();
        MinecartLines lines = this.getMinecartLines(level, tileX, tileY, rotation, 0.0f, 0.0f, false);
        if (lines.up != null) {
            MinecartLine upLine;
            out.goingUp();
            MinecartLine minecartLine = upLine = lines.up.nextNegative != null ? (MinecartLine)lines.up.nextNegative.get() : null;
            if (upLine == null) {
                out.connectedUp = false;
            }
        }
        if (lines.right != null) {
            MinecartLine rightLine;
            out.goingRight();
            MinecartLine minecartLine = rightLine = lines.right.nextPositive != null ? (MinecartLine)lines.right.nextPositive.get() : null;
            if (rightLine == null) {
                out.connectedRight = false;
            }
        }
        if (lines.down != null) {
            MinecartLine downLine;
            out.goingDown();
            MinecartLine minecartLine = downLine = lines.down.nextPositive != null ? (MinecartLine)lines.down.nextPositive.get() : null;
            if (downLine == null) {
                out.connectedDown = false;
            }
        }
        if (lines.left != null) {
            MinecartLine leftLine;
            out.goingLeft();
            MinecartLine minecartLine = leftLine = lines.left.nextNegative != null ? (MinecartLine)lines.left.nextNegative.get() : null;
            if (leftLine == null) {
                out.connectedLeft = false;
            }
        }
        switch (rotation) {
            case 0: {
                if (out.connectedLeft && out.connectedRight) {
                    return out.sprite(4, 0);
                }
                if (out.connectedLeft && out.connectedDown) {
                    return out.sprite(3, 3);
                }
                if (out.connectedRight && out.connectedDown) {
                    return out.sprite(2, 3);
                }
                if (out.connectedLeft) {
                    return out.sprite(3, 1);
                }
                if (out.connectedRight) {
                    return out.sprite(2, 1);
                }
                return out.sprite(1, 0);
            }
            case 1: {
                if (out.connectedUp && out.connectedDown) {
                    return out.sprite(4, 0);
                }
                if (out.connectedUp && out.connectedLeft) {
                    return out.sprite(0, 3);
                }
                if (out.connectedDown && out.connectedLeft) {
                    return out.sprite(0, 2);
                }
                if (out.connectedUp) {
                    return out.sprite(2, 1);
                }
                if (out.connectedDown) {
                    return out.sprite(2, 0);
                }
                return out.sprite(0, 0);
            }
            case 2: {
                if (out.connectedLeft && out.connectedRight) {
                    return out.sprite(4, 0);
                }
                if (out.connectedLeft && out.connectedUp) {
                    return out.sprite(3, 2);
                }
                if (out.connectedRight && out.connectedUp) {
                    return out.sprite(2, 2);
                }
                if (out.connectedLeft) {
                    return out.sprite(3, 0);
                }
                if (out.connectedRight) {
                    return out.sprite(2, 0);
                }
                return out.sprite(1, 0);
            }
            case 3: {
                if (out.connectedUp && out.connectedDown) {
                    return out.sprite(4, 0);
                }
                if (out.connectedUp && out.connectedRight) {
                    return out.sprite(1, 3);
                }
                if (out.connectedDown && out.connectedRight) {
                    return out.sprite(1, 2);
                }
                if (out.connectedUp) {
                    return out.sprite(3, 1);
                }
                if (out.connectedDown) {
                    return out.sprite(3, 0);
                }
                return out.sprite(0, 0);
            }
        }
        return out.sprite(0, 0);
    }

    public MinecartLines getMinecartLines(Level level, int x, int y, int rotation, float entityDx, float entityDy, boolean ignoreEntityDirection) {
        MinecartLines lines = new MinecartLines(x, y);
        boolean hasUp = Arrays.stream(this.railIds).anyMatch(level.getObject(x, y - 1).getStringID()::equals);
        boolean hasRight = Arrays.stream(this.railIds).anyMatch(level.getObject(x + 1, y).getStringID()::equals);
        boolean hasDown = Arrays.stream(this.railIds).anyMatch(level.getObject(x, y + 1).getStringID()::equals);
        boolean hasLeft = Arrays.stream(this.railIds).anyMatch(level.getObject(x - 1, y).getStringID()::equals);
        float turnThreshold = 0.2f;
        if (rotation != 0 && rotation != 2) {
            byte downRotation;
            boolean success;
            byte upRotation;
            boolean straightAcross = false;
            boolean anyConnectionFromSides = false;
            if (hasUp && ((upRotation = level.getObjectRotation(x, y - 1)) == 0 || upRotation == 2)) {
                byte downRotation2;
                success = true;
                if (hasDown && ((downRotation2 = level.getObjectRotation(x, y + 1)) == 0 || downRotation2 == 2)) {
                    success = false;
                }
                if (success) {
                    lines.up = MinecartLine.up((int)x, (int)y);
                    lines.up.nextNegative = () -> this.getMinecartLines((Level)level, (int)x, (int)(y - 1), (float)entityDx, (float)entityDy, (boolean)false).down;
                    anyConnectionFromSides = true;
                } else {
                    straightAcross = true;
                }
            }
            if (hasDown && ((downRotation = level.getObjectRotation(x, y + 1)) == 0 || downRotation == 2)) {
                byte upRotation2;
                success = true;
                if (hasUp && ((upRotation2 = level.getObjectRotation(x, y - 1)) == 0 || upRotation2 == 2)) {
                    success = false;
                }
                if (success) {
                    lines.down = MinecartLine.down((int)x, (int)y);
                    lines.down.nextPositive = () -> this.getMinecartLines((Level)level, (int)x, (int)(y + 1), (float)entityDx, (float)entityDy, (boolean)false).up;
                    anyConnectionFromSides = true;
                } else {
                    straightAcross = true;
                }
            }
            if (hasLeft) {
                lines.left = MinecartLine.left((int)x, (int)y);
                lines.left.nextNegative = () -> this.getMinecartLines((Level)level, (int)(x - 1), (int)y, (float)entityDx, (float)entityDy, (boolean)false).right;
            } else if (rotation == 3 || !anyConnectionFromSides) {
                lines.left = MinecartLine.leftEnd((int)x, (int)y);
                lines.left.nextNegative = null;
            }
            if (hasRight) {
                lines.right = MinecartLine.right((int)x, (int)y);
                lines.right.nextPositive = () -> this.getMinecartLines((Level)level, (int)(x + 1), (int)y, (float)entityDx, (float)entityDy, (boolean)false).left;
            } else if (rotation == 1 || !anyConnectionFromSides) {
                lines.right = MinecartLine.rightEnd((int)x, (int)y);
                lines.right.nextPositive = null;
            }
            if (lines.left != null && lines.right != null) {
                lines.left.nextPositive = () -> lines.right;
                lines.right.nextNegative = () -> lines.left;
            }
            if (straightAcross) {
                lines.up = MinecartLine.up((int)x, (int)y);
                lines.up.nextNegative = () -> this.getMinecartLines((Level)level, (int)x, (int)(y - 1), (float)entityDx, (float)entityDy, (boolean)false).down;
                lines.down = MinecartLine.down((int)x, (int)y);
                lines.down.nextPositive = () -> this.getMinecartLines((Level)level, (int)x, (int)(y + 1), (float)entityDx, (float)entityDy, (boolean)false).up;
                lines.up.nextPositive = () -> lines.down;
                lines.down.nextNegative = () -> lines.up;
            } else if (lines.down != null) {
                lines.down.nextPositive = () -> this.getMinecartLines((Level)level, (int)x, (int)(y + 1), (float)entityDx, (float)entityDy, (boolean)false).up;
                if (rotation == 1) {
                    if (lines.left == null || entityDy > turnThreshold) {
                        lines.right.nextNegative = () -> lines.down;
                    }
                    lines.down.nextNegative = () -> lines.right;
                } else {
                    if ((lines.right == null || entityDy > turnThreshold) && lines.left != null) {
                        lines.left.nextPositive = () -> lines.down;
                    }
                    lines.down.nextNegative = () -> lines.left;
                }
            } else if (lines.up != null) {
                lines.up.nextNegative = () -> this.getMinecartLines((Level)level, (int)x, (int)(y - 1), (float)entityDx, (float)entityDy, (boolean)false).down;
                if (rotation == 1) {
                    if (lines.left == null || entityDy < -turnThreshold) {
                        lines.right.nextNegative = () -> lines.up;
                    }
                    lines.up.nextPositive = () -> lines.right;
                } else {
                    if ((lines.right == null || entityDy < -turnThreshold) && lines.left != null) {
                        lines.left.nextPositive = () -> lines.up;
                    }
                    lines.up.nextPositive = () -> lines.left;
                }
            }
        } else {
            byte rightRotation;
            boolean success;
            byte leftRotation;
            boolean straightAcross = false;
            boolean anyConnectionFromSides = false;
            if (hasLeft && ((leftRotation = level.getObjectRotation(x - 1, y)) == 1 || leftRotation == 3)) {
                byte rightRotation2;
                success = true;
                if (hasRight && ((rightRotation2 = level.getObjectRotation(x + 1, y)) == 1 || rightRotation2 == 3)) {
                    success = false;
                }
                if (success) {
                    lines.left = MinecartLine.left((int)x, (int)y);
                    lines.left.nextNegative = () -> this.getMinecartLines((Level)level, (int)(x - 1), (int)y, (float)entityDx, (float)entityDy, (boolean)false).right;
                    anyConnectionFromSides = true;
                } else {
                    straightAcross = true;
                }
            }
            if (hasRight && ((rightRotation = level.getObjectRotation(x + 1, y)) == 1 || rightRotation == 3)) {
                byte leftRotation2;
                success = true;
                if (hasLeft && ((leftRotation2 = level.getObjectRotation(x - 1, y)) == 1 || leftRotation2 == 3)) {
                    success = false;
                }
                if (success) {
                    lines.right = MinecartLine.right((int)x, (int)y);
                    lines.right.nextPositive = () -> this.getMinecartLines((Level)level, (int)(x + 1), (int)y, (float)entityDx, (float)entityDy, (boolean)false).left;
                    anyConnectionFromSides = true;
                } else {
                    straightAcross = true;
                }
            }
            if (hasUp) {
                lines.up = MinecartLine.up((int)x, (int)y);
                lines.up.nextNegative = () -> this.getMinecartLines((Level)level, (int)x, (int)(y - 1), (float)entityDx, (float)entityDy, (boolean)false).down;
            } else if (rotation == 0 || !anyConnectionFromSides) {
                lines.up = MinecartLine.upEnd((int)x, (int)y);
                lines.up.nextNegative = null;
            }
            if (hasDown) {
                lines.down = MinecartLine.down((int)x, (int)y);
                lines.down.nextPositive = () -> this.getMinecartLines((Level)level, (int)x, (int)(y + 1), (float)entityDx, (float)entityDy, (boolean)false).up;
            } else if (rotation == 2 || !anyConnectionFromSides) {
                lines.down = MinecartLine.downEnd((int)x, (int)y);
                lines.down.nextPositive = null;
            }
            if (lines.up != null && lines.down != null) {
                lines.up.nextPositive = () -> lines.down;
                lines.down.nextNegative = () -> lines.up;
            }
            if (straightAcross) {
                lines.left = MinecartLine.left((int)x, (int)y);
                lines.left.nextNegative = () -> this.getMinecartLines((Level)level, (int)(x - 1), (int)y, (float)entityDx, (float)entityDy, (boolean)false).right;
                lines.right = MinecartLine.right((int)x, (int)y);
                lines.right.nextPositive = () -> this.getMinecartLines((Level)level, (int)(x + 1), (int)y, (float)entityDx, (float)entityDy, (boolean)false).left;
                lines.left.nextPositive = () -> lines.right;
                lines.right.nextNegative = () -> lines.left;
            } else if (lines.right != null) {
                lines.right.nextPositive = () -> this.getMinecartLines((Level)level, (int)(x + 1), (int)y, (float)entityDx, (float)entityDy, (boolean)false).left;
                if (rotation == 2) {
                    if (lines.up == null || entityDx > turnThreshold && !ignoreEntityDirection) {
                        lines.down.nextNegative = () -> lines.right;
                    }
                    lines.right.nextNegative = () -> lines.down;
                } else {
                    if ((lines.down == null || entityDx > turnThreshold && !ignoreEntityDirection) && lines.up != null) {
                        lines.up.nextPositive = () -> lines.right;
                    }
                    lines.right.nextNegative = () -> lines.up;
                }
            } else if (lines.left != null) {
                lines.left.nextNegative = () -> this.getMinecartLines((Level)level, (int)(x - 1), (int)y, (float)entityDx, (float)entityDy, (boolean)false).right;
                if (rotation == 2) {
                    if (lines.up == null || entityDx < -turnThreshold) {
                        lines.down.nextNegative = () -> lines.left;
                    }
                    lines.left.nextPositive = () -> lines.down;
                } else {
                    if ((lines.down == null || entityDx < -turnThreshold) && lines.up != null) {
                        lines.up.nextPositive = () -> lines.left;
                    }
                    lines.left.nextPositive = () -> lines.up;
                }
            }
        }
        return lines;
    }

    protected static class TrackSprite {
        public int x;
        public int y;
        public boolean goingUp;
        public boolean goingRight;
        public boolean goingDown;
        public boolean goingLeft;
        public boolean connectedUp;
        public boolean connectedRight;
        public boolean connectedDown;
        public boolean connectedLeft;

        protected TrackSprite() {
        }

        public void goingUp() {
            this.goingUp = true;
            this.connectedUp = true;
        }

        public void goingRight() {
            this.goingRight = true;
            this.connectedRight = true;
        }

        public void goingDown() {
            this.goingDown = true;
            this.connectedDown = true;
        }

        public void goingLeft() {
            this.goingLeft = true;
            this.connectedLeft = true;
        }

        public TrackSprite sprite(int spriteX, int spriteY) {
            this.x = spriteX;
            this.y = spriteY;
            return this;
        }
    }
}

