/*
 * Decompiled with CFR 0.152.
 */
package theholyrailmod.theholyrail;

import java.awt.Point;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import necesse.engine.GameEvents;
import necesse.engine.events.GameEvent;
import necesse.engine.events.loot.MobLootTableDropsEvent;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.localization.Localization;
import necesse.engine.network.Packet;
import necesse.engine.network.PacketReader;
import necesse.engine.network.PacketWriter;
import necesse.engine.network.packet.PacketOpenContainer;
import necesse.engine.network.server.ServerClient;
import necesse.engine.registries.ContainerRegistry;
import necesse.engine.registries.MobRegistry;
import necesse.engine.save.LoadData;
import necesse.engine.save.SaveData;
import necesse.engine.save.levelData.InventorySave;
import necesse.engine.sound.SoundPlayer;
import necesse.engine.util.GameRandom;
import necesse.entity.Entity;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.MobDrawable;
import necesse.entity.mobs.MobInventory;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.summon.MinecartLinePos;
import necesse.entity.mobs.summon.MinecartLines;
import necesse.entity.mobs.summon.MinecartMob;
import necesse.entity.pickup.ItemPickupEntity;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.DrawOptions;
import necesse.gfx.drawOptions.texture.TextureDrawOptionsEnd;
import necesse.gfx.drawables.OrderableDrawables;
import necesse.gfx.gameTexture.GameTexture;
import necesse.inventory.Inventory;
import necesse.inventory.InventoryItem;
import necesse.inventory.lootTable.LootItemInterface;
import necesse.inventory.lootTable.LootTable;
import necesse.inventory.lootTable.lootItem.LootItem;
import necesse.level.gameObject.GameObject;
import necesse.level.gameObject.MinecartTrackObject;
import necesse.level.maps.Level;
import necesse.level.maps.levelBuffManager.LevelModifiers;
import necesse.level.maps.light.GameLight;
import theholyrailmod.container.ChestMinecartContainer;

public class ChestMinecartMob
extends MinecartMob
implements MobInventory {
    public static LootTable lootTable = new LootTable(new LootItemInterface[]{new LootItem("chestminecart")});
    public static GameTexture texture;
    public static GameTexture openTexture;
    public float collisionMovementBuffer;
    public Point collisionMovementLastPos;
    public float chestMinecartSpeed;
    public int chestMinecartDir;
    public boolean isOpened;
    public boolean isMakingStop;
    public Inventory itemInventory = new Inventory(20);
    public int filledInventorySlots;
    protected SoundPlayer movingSound;
    protected SoundPlayer breakingSound;
    protected float breakParticleBuffer;
    protected boolean breakParticleAlternate;
    public long stationedTime = -1L;
    public long lastStationLeft = -2L;
    public boolean isBeingStationed = false;
    public final long STATION_COOLDOWN_TIME = 350L;
    public final float MAX_SPEED = 190.0f;
    public final float BOOST_SPEED = 767.6f;

    public ChestMinecartMob() {
        this.setSpeed(190.0f);
        this.setFriction(3.2f);
        this.accelerationMod = 0.08f;
        this.filledInventorySlots = 0;
    }

    public void addSaveData(SaveData save) {
        super.addSaveData(save);
        save.addInt("chestMinecartDir", this.chestMinecartDir);
        save.addFloat("chestMinecartSpeed", this.chestMinecartSpeed);
        save.addLong("lastStationLeft", this.lastStationLeft);
        save.addLong("stationedTime", this.stationedTime);
        save.addBoolean("isBeingStationed", this.isBeingStationed);
        save.addBoolean("isOpened", this.isOpened);
        save.addSaveData(InventorySave.getSave((Inventory)this.itemInventory, (String)"items"));
    }

    public void applyLoadData(LoadData save) {
        super.applyLoadData(save);
        this.chestMinecartDir = save.getInt("chestMinecartDir", this.chestMinecartDir);
        this.chestMinecartSpeed = save.getFloat("chestMinecartSpeed", this.chestMinecartSpeed);
        this.lastStationLeft = save.getLong("lastStationLeft", this.lastStationLeft);
        this.stationedTime = save.getLong("stationedTime", this.stationedTime);
        this.isBeingStationed = save.getBoolean("isBeingStationed", this.isBeingStationed);
        this.isOpened = save.getBoolean("isOpened", this.isOpened);
        LoadData itemSave = save.getFirstLoadDataByName("items");
        if (itemSave != null) {
            this.itemInventory.override(InventorySave.loadSave((LoadData)itemSave));
        }
        this.getFilledInventorySlots(true);
    }

    public void setupMovementPacket(PacketWriter writer) {
        super.setupMovementPacket(writer);
        writer.putNextBoolean(this.isBeingStationed);
        writer.putNextLong(this.lastStationLeft);
        writer.putNextLong(this.stationedTime);
        writer.putNextFloat(this.chestMinecartSpeed);
        writer.putNextMaxValue(this.chestMinecartDir, 3);
    }

    public void applyMovementPacket(PacketReader reader, boolean isDirect) {
        super.applyMovementPacket(reader, isDirect);
        this.isBeingStationed = reader.getNextBoolean();
        this.lastStationLeft = reader.getNextLong();
        this.stationedTime = reader.getNextLong();
        this.chestMinecartSpeed = reader.getNextFloat();
        this.chestMinecartDir = reader.getNextMaxValue(3);
    }

    public LootTable getLootTable() {
        return lootTable;
    }

    public void serverTick() {
        super.serverTick();
        this.serverTickInventorySync(this.getLevel().getServer(), (Mob)this);
    }

    public void setupSpawnPacket(PacketWriter writer) {
        super.setupSpawnPacket(writer);
        this.itemInventory.writeContent(writer);
    }

    public void applySpawnPacket(PacketReader reader) {
        super.applySpawnPacket(reader);
        this.itemInventory.override(Inventory.getInventory((PacketReader)reader), this.hasArrivedAtTarget, this.hasArrivedAtTarget);
        this.getFilledInventorySlots(true);
    }

    public void addDrawables(List<MobDrawable> list, OrderableDrawables tileList, OrderableDrawables topList, Level level, int x, int y, TickManager tickManager, GameCamera camera, PlayerMob perspective) {
        super.addDrawables(list, tileList, topList, level, x, y, tickManager, camera, perspective);
        GameLight light = level.getLightLevel(this.getTileX(), this.getTileY());
        int drawX = camera.getDrawX(x) - 32;
        int drawY = camera.getDrawY(y) - 51;
        Point sprite = this.getAnimSprite(x, y, this.getDir());
        drawY += this.getBobbing(x, y);
        TextureDrawOptionsEnd behind = texture.initDraw().sprite(sprite.x, sprite.y, 64).light(light).pos(drawX, drawY += this.getLevel().getTile(this.getTileX(), this.getTileY()).getMobSinkingAmount((Mob)this));
        TextureDrawOptionsEnd drawOptions = this.isOpened ? openTexture.initDraw().sprite(sprite.x, sprite.y, 64).light(light).pos(drawX, drawY) : texture.initDraw().sprite(sprite.x, sprite.y, 64).light(light).pos(drawX, drawY);
        list.add(new MobDrawable((DrawOptions)drawOptions, (DrawOptions)behind){
            final /* synthetic */ DrawOptions val$drawOptions;
            final /* synthetic */ DrawOptions val$behind;
            {
                this.val$drawOptions = drawOptions;
                this.val$behind = drawOptions2;
            }

            public void draw(TickManager tickManager) {
                this.val$drawOptions.draw();
            }

            public void drawBehindRider(TickManager tickManager) {
                this.val$behind.draw();
            }
        });
        this.addShadowDrawables(tileList, level, x, y, light, camera);
    }

    public void onDeath(Attacker attacker, HashSet<Attacker> attackers) {
        super.onDeath(attacker, attackers);
        ArrayList<InventoryItem> containedItems = new ArrayList<InventoryItem>();
        for (int i = 0; i < this.itemInventory.getSize(); ++i) {
            containedItems.add(this.itemInventory.getItem(i));
        }
        ArrayList drops = this.getLootTable().getNewList(GameRandom.globalRandom, ((Float)this.getLevel().buffManager.getModifier(LevelModifiers.LOOT)).floatValue(), new Object[]{this});
        Point publicLootPosition = this.getLootDropsPosition(null);
        MobLootTableDropsEvent dropEvent = new MobLootTableDropsEvent((Mob)this, publicLootPosition, drops);
        GameEvents.triggerEvent((GameEvent)dropEvent);
        if (dropEvent.dropPos != null && dropEvent.drops != null) {
            for (InventoryItem item : containedItems) {
                if (item == null) continue;
                ItemPickupEntity entity = item.getPickupEntity(this.getLevel(), (float)dropEvent.dropPos.x, (float)dropEvent.dropPos.y);
                this.getLevel().entityManager.pickups.add((Entity)entity);
            }
            this.itemInventory.clearInventory();
        }
    }

    public static void drawPlacePreview(Level level, int levelX, int levelY, int dir, GameCamera camera) {
        Mob mob = MobRegistry.getMob((String)"chestminecartmob", (Level)level);
        if (mob != null) {
            mob.setPos((float)levelX, (float)levelY, true);
            int tileX = mob.getTileX();
            int tileY = mob.getTileY();
            GameObject object = level.getObject(tileX, tileY);
            if (object instanceof MinecartTrackObject) {
                MinecartTrackObject trackObject = (MinecartTrackObject)object;
                float moveX = 0.0f;
                float moveY = 0.0f;
                if (dir == 0) {
                    moveY = -1.0f;
                } else if (dir == 1) {
                    moveX = 1.0f;
                } else if (dir == 2) {
                    moveY = 1.0f;
                } else {
                    moveX = -1.0f;
                }
                MinecartLines lines = trackObject.getMinecartLines(level, tileX, tileY, moveX, moveY, false);
                MinecartLinePos pos = lines.getMinecartPos((float)levelX, (float)levelY, dir);
                if (pos != null) {
                    int drawX = camera.getDrawX(pos.x) - 32;
                    int drawY = camera.getDrawY(pos.y) - 47;
                    Point sprite = mob.getAnimSprite((int)pos.x, (int)pos.y, pos.dir);
                    drawY += mob.getBobbing((int)pos.x, (int)pos.y);
                    texture.initDraw().sprite(sprite.x, sprite.y, 64).alpha(0.5f).draw(drawX, drawY += level.getTile((int)pos.x / 32, (int)pos.y / 32).getMobSinkingAmount(mob));
                    return;
                }
            }
        }
        int drawX = camera.getDrawX(levelX) - 32;
        int drawY = camera.getDrawY(levelY) - 47;
        texture.initDraw().sprite(0, dir, 64).alpha(0.5f).draw(drawX, drawY += level.getLevelTile(levelX / 32, levelY / 32).getLiquidBobbing());
    }

    public boolean canInteract(Mob mob) {
        return true;
    }

    public String getInteractTip(PlayerMob perspective, boolean debug) {
        return this.isOpened ? null : Localization.translate((String)"controls", (String)"opentip");
    }

    public void interact(PlayerMob player) {
        Level level = player.getLevel();
        if (level.isServer() && player.isServerClient()) {
            ServerClient client = player.getServerClient();
            int CHEST_MINECART_CONTAINER = ChestMinecartContainer.registryId;
            PacketOpenContainer p = PacketOpenContainer.Mob((int)CHEST_MINECART_CONTAINER, (Mob)this, (Packet)ChestMinecartContainer.getChestMinecartContent(this, client.getServer(), client));
            ContainerRegistry.openAndSendContainer((ServerClient)client, (PacketOpenContainer)p);
        }
    }

    public Inventory getInventory() {
        return this.itemInventory;
    }

    public Inventory getInventory(Packet contentPacket) {
        return this.getInventory(new PacketReader(contentPacket));
    }

    public Inventory getInventory(PacketReader reader) {
        int size = reader.getNextShortUnsigned();
        Inventory out = new Inventory(size){

            public boolean canLockItem(int slot) {
                return true;
            }
        };
        for (int i = 0; i < out.getSize(); ++i) {
            if (!reader.getNextBoolean()) continue;
            out.setItem(i, InventoryItem.fromContentPacket((PacketReader)reader));
        }
        return out;
    }

    public int getFilledInventorySlots(boolean recalc) {
        if (recalc) {
            int invSize = this.getInventory().getSize();
            int totalFilledSlots = 0;
            for (int i = 0; i < invSize; ++i) {
                if (this.getInventory().isSlotClear(i)) continue;
                ++totalFilledSlots;
            }
            return totalFilledSlots;
        }
        return this.filledInventorySlots;
    }

    public void setFilledInventorySlots(int filledSlots) {
        this.filledInventorySlots = filledSlots;
    }

    public void getAndSetFilledInventorySlots() {
        int invSize = this.getInventory().getSize();
        int totalFilledSlots = 0;
        for (int i = 0; i < invSize; ++i) {
            if (this.getInventory().isSlotClear(i)) continue;
            ++totalFilledSlots;
        }
        this.filledInventorySlots = totalFilledSlots;
    }

    public void sortItems(PlayerMob playerMob) {
        this.itemInventory.sortItems(this.getLevel(), playerMob, 0, this.itemInventory.getSize() - 1);
    }

    public ChestMinecartMob getMob() {
        return this;
    }

    public boolean getIsOpened() {
        return this.isOpened;
    }

    public void setIsOpened(boolean opened) {
        this.isOpened = opened;
    }

    public boolean getIsMakingStop() {
        return this.isMakingStop;
    }

    public void setIsMakingStop(boolean stopping) {
        this.isMakingStop = stopping;
    }

    public long getStationedTime() {
        return this.stationedTime;
    }

    public void setStationedTime(long stationedDur) {
        this.stationedTime = stationedDur;
    }

    public long getLastStationLeft() {
        return this.lastStationLeft;
    }

    public void setLastStationLeft(long stationedLeft) {
        this.lastStationLeft = stationedLeft;
    }

    public boolean getIsBeingStationed() {
        return this.isBeingStationed;
    }

    public void setIsBeingStationed(boolean beingStationed) {
        this.isBeingStationed = beingStationed;
    }

    public long getTimeSinceStationed(ChestMinecartMob mob) {
        if (this.stationedTime < 0L) {
            return this.stationedTime;
        }
        return this.isBeingStationed ? mob.getWorldEntity().getTime() - this.stationedTime : -1L;
    }

    public long getTimeSinceLeftLastStation(ChestMinecartMob mob) {
        if (this.lastStationLeft < 0L) {
            return this.lastStationLeft;
        }
        return this.isBeingStationed ? -1L : mob.getWorldEntity().getTime() - this.lastStationLeft;
    }

    public boolean getIsInventoryEmpty() {
        return this.getFilledInventorySlots(false) == 0;
    }

    public boolean getIsInventoryFull() {
        return this.getFilledInventorySlots(false) == this.getInventory().getSize();
    }

    public static int registerChestMinecartMob() {
        return MobRegistry.registerMob((String)"chestminecartmob", ChestMinecartMob.class, (boolean)false);
    }
}

