/*
 * Decompiled with CFR 0.152.
 */
package theholyrailmod.patch;

import java.util.Arrays;
import necesse.engine.modLoader.annotations.ModMethodPatch;
import necesse.entity.mobs.summon.MinecartLine;
import necesse.entity.mobs.summon.MinecartLines;
import necesse.level.gameObject.MinecartTrackObject;
import necesse.level.maps.Level;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.implementation.bytecode.assign.Assigner;

public class MinecartTrackObjectPatch {

    @ModMethodPatch(target=MinecartTrackObject.class, name="getMinecartLines", arguments={Level.class, int.class, int.class, float.class, float.class, boolean.class})
    public static class AddHolyRailInteroperability {
        @Advice.OnMethodEnter(skipOn=Advice.OnNonDefaultValue.class)
        public static MinecartLines onEnter(@Advice.This MinecartTrackObject obj, @Advice.Argument(value=0) Level level, @Advice.Argument(value=1) int x, @Advice.Argument(value=2) int y, @Advice.Argument(value=3) float entityDx, @Advice.Argument(value=4) float entityDy, @Advice.Argument(value=5) boolean ignoreEntityDirection) {
            return AddHolyRailInteroperability.getMinecartLines(obj, level, x, y, entityDx, entityDy, ignoreEntityDirection);
        }

        @Advice.OnMethodExit
        public static void onExit(@Advice.Return(readOnly=false, typing=Assigner.Typing.DYNAMIC) Object returned, @Advice.Enter Object enter) {
            if (enter != null) {
                returned = enter;
            }
        }

        public static MinecartLines getMinecartLines(MinecartTrackObject obj, Level level, int x, int y, float entityDx, float entityDy, boolean ignoreEntityDirection) {
            String[] railIds = new String[]{"minecarttrack", "poweredrail", "stationtrack"};
            MinecartLines lines = new MinecartLines(x, y);
            byte rotation = level.getObjectRotation(x, y);
            boolean hasUp = Arrays.stream(railIds).anyMatch(level.getObject(x, y - 1).getStringID()::equals);
            boolean hasDown = Arrays.stream(railIds).anyMatch(level.getObject(x, y + 1).getStringID()::equals);
            boolean hasLeft = Arrays.stream(railIds).anyMatch(level.getObject(x - 1, y).getStringID()::equals);
            boolean hasRight = Arrays.stream(railIds).anyMatch(level.getObject(x + 1, y).getStringID()::equals);
            float turnThreshold = 0.2f;
            if (rotation != 0 && rotation != 2) {
                byte downRotation;
                boolean success;
                byte upRotation;
                boolean straightAcross = false;
                boolean anyConnectionFromSides = false;
                if (hasUp && ((upRotation = level.getObjectRotation(x, y - 1)) == 0 || upRotation == 2)) {
                    byte downRotation2;
                    success = true;
                    if (hasDown && ((downRotation2 = level.getObjectRotation(x, y + 1)) == 0 || downRotation2 == 2)) {
                        success = false;
                    }
                    if (success) {
                        lines.up = MinecartLine.up((int)x, (int)y);
                        lines.up.nextNegative = () -> AddHolyRailInteroperability.getMinecartLines((MinecartTrackObject)obj, (Level)level, (int)x, (int)(y - 1), (float)entityDx, (float)entityDy, (boolean)ignoreEntityDirection).down;
                        anyConnectionFromSides = true;
                    } else {
                        straightAcross = true;
                    }
                }
                if (hasDown && ((downRotation = level.getObjectRotation(x, y + 1)) == 0 || downRotation == 2)) {
                    byte upRotation2;
                    success = true;
                    if (hasUp && ((upRotation2 = level.getObjectRotation(x, y - 1)) == 0 || upRotation2 == 2)) {
                        success = false;
                    }
                    if (success) {
                        lines.down = MinecartLine.down((int)x, (int)y);
                        lines.down.nextPositive = () -> AddHolyRailInteroperability.getMinecartLines((MinecartTrackObject)obj, (Level)level, (int)x, (int)(y + 1), (float)entityDx, (float)entityDy, (boolean)ignoreEntityDirection).up;
                        anyConnectionFromSides = true;
                    } else {
                        straightAcross = true;
                    }
                }
                if (hasLeft) {
                    lines.left = MinecartLine.left((int)x, (int)y);
                    lines.left.nextNegative = () -> AddHolyRailInteroperability.getMinecartLines((MinecartTrackObject)obj, (Level)level, (int)(x - 1), (int)y, (float)entityDx, (float)entityDy, (boolean)ignoreEntityDirection).right;
                } else if (rotation == 3 || !anyConnectionFromSides) {
                    lines.left = MinecartLine.leftEnd((int)x, (int)y);
                    lines.left.nextNegative = null;
                }
                if (hasRight) {
                    lines.right = MinecartLine.right((int)x, (int)y);
                    lines.right.nextPositive = () -> AddHolyRailInteroperability.getMinecartLines((MinecartTrackObject)obj, (Level)level, (int)(x + 1), (int)y, (float)entityDx, (float)entityDy, (boolean)ignoreEntityDirection).left;
                } else if (rotation == 1 || !anyConnectionFromSides) {
                    lines.right = MinecartLine.rightEnd((int)x, (int)y);
                    lines.right.nextPositive = null;
                }
                if (lines.left != null && lines.right != null) {
                    lines.left.nextPositive = () -> lines.right;
                    lines.right.nextNegative = () -> lines.left;
                }
                if (straightAcross) {
                    lines.up = MinecartLine.up((int)x, (int)y);
                    lines.up.nextNegative = () -> AddHolyRailInteroperability.getMinecartLines((MinecartTrackObject)obj, (Level)level, (int)x, (int)(y - 1), (float)entityDx, (float)entityDy, (boolean)ignoreEntityDirection).down;
                    lines.down = MinecartLine.down((int)x, (int)y);
                    lines.down.nextPositive = () -> AddHolyRailInteroperability.getMinecartLines((MinecartTrackObject)obj, (Level)level, (int)x, (int)(y + 1), (float)entityDx, (float)entityDy, (boolean)ignoreEntityDirection).up;
                    lines.up.nextPositive = () -> lines.down;
                    lines.down.nextNegative = () -> lines.up;
                } else if (lines.down != null) {
                    lines.down.nextPositive = () -> AddHolyRailInteroperability.getMinecartLines((MinecartTrackObject)obj, (Level)level, (int)x, (int)(y + 1), (float)entityDx, (float)entityDy, (boolean)ignoreEntityDirection).up;
                    if (rotation == 1) {
                        if (lines.left == null || entityDy > turnThreshold) {
                            lines.right.nextNegative = () -> lines.down;
                        }
                        lines.down.nextNegative = () -> lines.right;
                    } else {
                        if ((lines.right == null || entityDy > turnThreshold) && lines.left != null) {
                            lines.left.nextPositive = () -> lines.down;
                        }
                        lines.down.nextNegative = () -> lines.left;
                    }
                } else if (lines.up != null) {
                    lines.up.nextNegative = () -> AddHolyRailInteroperability.getMinecartLines((MinecartTrackObject)obj, (Level)level, (int)x, (int)(y - 1), (float)entityDx, (float)entityDy, (boolean)ignoreEntityDirection).down;
                    if (rotation == 1) {
                        if (lines.left == null || entityDy < -turnThreshold) {
                            lines.right.nextNegative = () -> lines.up;
                        }
                        lines.up.nextPositive = () -> lines.right;
                    } else {
                        if ((lines.right == null || entityDy < -turnThreshold) && lines.left != null) {
                            lines.left.nextPositive = () -> lines.up;
                        }
                        lines.up.nextPositive = () -> lines.left;
                    }
                }
            } else {
                byte rightRotation;
                boolean success;
                byte leftRotation;
                boolean straightAcross = false;
                boolean anyConnectionFromSides = false;
                if (hasLeft && ((leftRotation = level.getObjectRotation(x - 1, y)) == 1 || leftRotation == 3)) {
                    byte rightRotation2;
                    success = true;
                    if (hasRight && ((rightRotation2 = level.getObjectRotation(x + 1, y)) == 1 || rightRotation2 == 3)) {
                        success = false;
                    }
                    if (success) {
                        lines.left = MinecartLine.left((int)x, (int)y);
                        lines.left.nextNegative = () -> AddHolyRailInteroperability.getMinecartLines((MinecartTrackObject)obj, (Level)level, (int)(x - 1), (int)y, (float)entityDx, (float)entityDy, (boolean)ignoreEntityDirection).right;
                        anyConnectionFromSides = true;
                    } else {
                        straightAcross = true;
                    }
                }
                if (hasRight && ((rightRotation = level.getObjectRotation(x + 1, y)) == 1 || rightRotation == 3)) {
                    byte leftRotation2;
                    success = true;
                    if (hasLeft && ((leftRotation2 = level.getObjectRotation(x - 1, y)) == 1 || leftRotation2 == 3)) {
                        success = false;
                    }
                    if (success) {
                        lines.right = MinecartLine.right((int)x, (int)y);
                        lines.right.nextPositive = () -> AddHolyRailInteroperability.getMinecartLines((MinecartTrackObject)obj, (Level)level, (int)(x + 1), (int)y, (float)entityDx, (float)entityDy, (boolean)ignoreEntityDirection).left;
                        anyConnectionFromSides = true;
                    } else {
                        straightAcross = true;
                    }
                }
                if (hasUp) {
                    lines.up = MinecartLine.up((int)x, (int)y);
                    lines.up.nextNegative = () -> AddHolyRailInteroperability.getMinecartLines((MinecartTrackObject)obj, (Level)level, (int)x, (int)(y - 1), (float)entityDx, (float)entityDy, (boolean)ignoreEntityDirection).down;
                } else if (rotation == 0 || !anyConnectionFromSides) {
                    lines.up = MinecartLine.upEnd((int)x, (int)y);
                    lines.up.nextNegative = null;
                }
                if (hasDown) {
                    lines.down = MinecartLine.down((int)x, (int)y);
                    lines.down.nextPositive = () -> AddHolyRailInteroperability.getMinecartLines((MinecartTrackObject)obj, (Level)level, (int)x, (int)(y + 1), (float)entityDx, (float)entityDy, (boolean)ignoreEntityDirection).up;
                } else if (rotation == 2 || !anyConnectionFromSides) {
                    lines.down = MinecartLine.downEnd((int)x, (int)y);
                    lines.down.nextPositive = null;
                }
                if (lines.up != null && lines.down != null) {
                    lines.up.nextPositive = () -> lines.down;
                    lines.down.nextNegative = () -> lines.up;
                }
                if (straightAcross) {
                    lines.left = MinecartLine.left((int)x, (int)y);
                    lines.left.nextNegative = () -> AddHolyRailInteroperability.getMinecartLines((MinecartTrackObject)obj, (Level)level, (int)(x - 1), (int)y, (float)entityDx, (float)entityDy, (boolean)ignoreEntityDirection).right;
                    lines.right = MinecartLine.right((int)x, (int)y);
                    lines.right.nextPositive = () -> AddHolyRailInteroperability.getMinecartLines((MinecartTrackObject)obj, (Level)level, (int)(x + 1), (int)y, (float)entityDx, (float)entityDy, (boolean)ignoreEntityDirection).left;
                    lines.left.nextPositive = () -> lines.right;
                    lines.right.nextNegative = () -> lines.left;
                } else if (lines.right != null) {
                    lines.right.nextPositive = () -> AddHolyRailInteroperability.getMinecartLines((MinecartTrackObject)obj, (Level)level, (int)(x + 1), (int)y, (float)entityDx, (float)entityDy, (boolean)ignoreEntityDirection).left;
                    if (rotation == 2) {
                        if (lines.up == null || entityDx > turnThreshold) {
                            lines.down.nextNegative = () -> lines.right;
                        }
                        lines.right.nextNegative = () -> lines.down;
                    } else {
                        if ((lines.down == null || entityDx > turnThreshold) && lines.up != null) {
                            lines.up.nextPositive = () -> lines.right;
                        }
                        lines.right.nextNegative = () -> lines.up;
                    }
                } else if (lines.left != null) {
                    lines.left.nextNegative = () -> AddHolyRailInteroperability.getMinecartLines((MinecartTrackObject)obj, (Level)level, (int)(x - 1), (int)y, (float)entityDx, (float)entityDy, (boolean)ignoreEntityDirection).right;
                    if (rotation == 2) {
                        if (lines.up == null || entityDx < -turnThreshold) {
                            lines.down.nextNegative = () -> lines.left;
                        }
                        lines.left.nextPositive = () -> lines.down;
                    } else {
                        if ((lines.down == null || entityDx < -turnThreshold) && lines.up != null) {
                            lines.up.nextPositive = () -> lines.left;
                        }
                        lines.left.nextPositive = () -> lines.up;
                    }
                }
            }
            return lines;
        }
    }
}

