/*
 * Decompiled with CFR 0.152.
 */
package theholyrailmod.patch;

import necesse.engine.modLoader.annotations.ModMethodPatch;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.summon.summonFollowingMob.mountFollowingMob.MinecartMountMob;
import necesse.level.gameObject.GameObject;
import net.bytebuddy.asm.Advice;
import theholyrailmod.theholyrail.PoweredRailObject;
import theholyrailmod.theholyrail.RailRunnerMob;
import theholyrailmod.theholyrail.StationTrackObject;
import theholyrailmod.theholyrail.StationTrackObjectEntity;

public class MinecartMountMobPatch {

    @ModMethodPatch(target=MinecartMountMob.class, name="tickCollisionMovement", arguments={float.class, Mob.class})
    public static class TickCollisionMovementPatch {
        public static StationTrackObjectEntity stationTrackEntity;

        @Advice.OnMethodEnter
        public static void onEnter(@Advice.This MinecartMountMob mobObject, @Advice.Argument(value=0) float delta, @Advice.Argument(value=1) Mob rider) {
            RailRunnerMob rrMob;
            int tileX = mobObject.getTileX();
            int tileY = mobObject.getTileY();
            GameObject trackObject = mobObject.getLevel().getObject(tileX, tileY);
            if (trackObject instanceof StationTrackObject) {
                stationTrackEntity = (StationTrackObjectEntity)mobObject.getLevel().entityManager.getObjectEntity(tileX, tileY);
            }
            RailRunnerMob railRunnerMob = rrMob = mobObject instanceof RailRunnerMob ? (RailRunnerMob)mobObject : null;
            if (!(mobObject instanceof RailRunnerMob)) {
                if (trackObject instanceof PoweredRailObject) {
                    if (((PoweredRailObject)trackObject).isPowered(mobObject.getLevel(), tileX, tileY) && rider != null) {
                        float MAX_SPEED = 200.0f;
                        float BOOST_SPEED = MAX_SPEED * 4.5f;
                        mobObject.minecartSpeed = Math.min(MAX_SPEED, mobObject.minecartSpeed + BOOST_SPEED * delta / 150.0f * mobObject.getAccelerationModifier());
                    } else {
                        mobObject.minecartSpeed = rider == null ? 0.0f : Math.min(0.0f, mobObject.minecartSpeed > 4.0f ? mobObject.minecartSpeed / 2.0f * delta / 250.0f : (mobObject.minecartSpeed > 0.0f ? (mobObject.minecartSpeed - 0.01f) * delta / 250.0f : 0.0f));
                    }
                }
            } else if (trackObject instanceof PoweredRailObject && mobObject instanceof RailRunnerMob) {
                mobObject.minecartSpeed = ((PoweredRailObject)trackObject).isPowered(mobObject.getLevel(), tileX, tileY) && rider != null ? Math.min(rrMob.MAX_SPEED, mobObject.minecartSpeed + rrMob.BOOST_SPEED * delta / 150.0f * mobObject.getAccelerationModifier()) : (rider == null ? 0.0f : Math.max(0.0f, mobObject.minecartSpeed > 12.0f ? mobObject.minecartSpeed / 2.0f * delta / 250.0f : (mobObject.minecartSpeed - 0.1f) * delta / 250.0f));
            }
        }
    }
}

