/*
 * Decompiled with CFR 0.152.
 */
package theholyrailmod.patch;

import necesse.engine.modLoader.annotations.ModMethodPatch;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.summon.MinecartMob;
import necesse.level.gameObject.GameObject;
import net.bytebuddy.asm.Advice;
import theholyrailmod.theholyrail.ChestMinecartMob;
import theholyrailmod.theholyrail.PoweredRailObject;
import theholyrailmod.theholyrail.StationTrackObject;
import theholyrailmod.theholyrail.StationTrackObjectEntity;

public class MinecartMobPatch {

    @ModMethodPatch(target=MinecartMob.class, name="tickCollisionMovement", arguments={float.class, Mob.class})
    public static class TickCollisionMovementPatch {
        public static StationTrackObjectEntity stationTrackEntity;

        @Advice.OnMethodEnter
        public static void onEnter(@Advice.This MinecartMob mobObject, @Advice.Argument(value=0) float delta, @Advice.Argument(value=1) Mob rider) {
            ChestMinecartMob cmMob;
            int tileX = mobObject.getTileX();
            int tileY = mobObject.getTileY();
            boolean waitSeconds = false;
            boolean waitEmpty = false;
            boolean waitFull = false;
            boolean roleLoad = false;
            boolean roleUnload = false;
            GameObject trackObject = mobObject.getLevel().getObject(tileX, tileY);
            if (trackObject instanceof StationTrackObject) {
                stationTrackEntity = (StationTrackObjectEntity)mobObject.getLevel().entityManager.getObjectEntity(tileX, tileY);
                waitSeconds = stationTrackEntity.getWaitSeconds();
                waitEmpty = stationTrackEntity.getWaitEmpty();
                waitFull = stationTrackEntity.getWaitFull();
                roleLoad = stationTrackEntity.getRoleLoad();
                roleUnload = stationTrackEntity.getRoleUnload();
            }
            ChestMinecartMob chestMinecartMob = cmMob = mobObject instanceof ChestMinecartMob ? (ChestMinecartMob)mobObject : null;
            if (!(mobObject instanceof ChestMinecartMob)) {
                if (trackObject instanceof PoweredRailObject) {
                    if (((PoweredRailObject)trackObject).isPowered(mobObject.getLevel(), tileX, tileY) && rider != null) {
                        float MAX_SPEED = 200.0f;
                        float BOOST_SPEED = MAX_SPEED * 4.5f;
                        mobObject.minecartSpeed = Math.min(MAX_SPEED, mobObject.minecartSpeed + BOOST_SPEED * delta / 150.0f * mobObject.getAccelerationModifier());
                    } else if (rider == null) {
                        float MAX_SPEED = 120.0f;
                        float BOOST_SPEED = MAX_SPEED * 4.15f;
                        mobObject.minecartSpeed = Math.min(MAX_SPEED, mobObject.minecartSpeed + BOOST_SPEED * delta / 160.0f * mobObject.getAccelerationModifier());
                    } else {
                        mobObject.minecartSpeed = Math.min(0.0f, mobObject.minecartSpeed > 4.0f ? mobObject.minecartSpeed / 2.0f * delta / 250.0f : (mobObject.minecartSpeed > 0.0f ? (mobObject.minecartSpeed - 0.01f) * delta / 250.0f : 0.0f));
                    }
                }
            } else {
                if (trackObject instanceof PoweredRailObject && mobObject instanceof ChestMinecartMob) {
                    cmMob.setIsBeingStationed(false);
                    mobObject.minecartSpeed = ((PoweredRailObject)trackObject).isPowered(mobObject.getLevel(), tileX, tileY) ? Math.min(cmMob.MAX_SPEED, mobObject.minecartSpeed + cmMob.BOOST_SPEED * delta / 150.0f * mobObject.getAccelerationModifier()) : Math.max(0.0f, mobObject.minecartSpeed > 8.0f ? mobObject.minecartSpeed / 2.0f * delta / 250.0f : (mobObject.minecartSpeed - 0.1f) * delta / 250.0f);
                }
                if (trackObject instanceof StationTrackObject && mobObject instanceof ChestMinecartMob) {
                    float inventoryAccelerationMod = Math.max(0.7f, Math.min(1.25f, (float)(4 / Math.min(10, cmMob.getFilledInventorySlots(false) + 1)) * 0.5f));
                    if (!(cmMob.getTimeSinceLeftLastStation((ChestMinecartMob)mobObject) <= cmMob.STATION_COOLDOWN_TIME && cmMob.getLastStationLeft() != -2L || waitSeconds && stationTrackEntity.getMaxStationWaitTime() == 0L)) {
                        mobObject.minecartSpeed = Math.max(0.0f, mobObject.minecartSpeed - (cmMob.minecartSpeed + cmMob.BOOST_SPEED) * delta / 28.0f * mobObject.getAccelerationModifier());
                        cmMob.sendMovementPacket(true);
                    } else if ((!cmMob.getIsOpened() && !cmMob.getIsBeingStationed() && cmMob.getTimeSinceLeftLastStation((ChestMinecartMob)mobObject) <= cmMob.STATION_COOLDOWN_TIME && cmMob.getLastStationLeft() != -2L || waitSeconds && stationTrackEntity.getMaxStationWaitTime() == 0L) && (!waitSeconds || stationTrackEntity.getMaxStationWaitTime() != 0L)) {
                        mobObject.minecartSpeed = Math.min(cmMob.MAX_SPEED, mobObject.minecartSpeed + cmMob.MAX_SPEED * inventoryAccelerationMod * delta / 150.0f * mobObject.getAccelerationModifier());
                    }
                    if (cmMob.getIsBeingStationed()) {
                        if (roleLoad) {
                            stationTrackEntity.transferItemsToMinecart(cmMob);
                        } else if (roleUnload) {
                            stationTrackEntity.transferItemsFromMinecart(cmMob);
                        }
                    }
                    if (!cmMob.getIsOpened()) {
                        if (mobObject.minecartSpeed <= 0.0f && !cmMob.getIsBeingStationed() && (cmMob.getTimeSinceLeftLastStation((ChestMinecartMob)mobObject) > cmMob.STATION_COOLDOWN_TIME || cmMob.getLastStationLeft() == -2L)) {
                            cmMob.setIsBeingStationed(true);
                            cmMob.setStationedTime(mobObject.getWorldEntity().getTime());
                            cmMob.setIsMakingStop(false);
                            cmMob.sendMovementPacket(true);
                        }
                        if (cmMob.getIsBeingStationed() && (waitSeconds && cmMob.getTimeSinceStationed((ChestMinecartMob)mobObject) >= stationTrackEntity.getMaxStationWaitTime() || waitEmpty && cmMob.getIsInventoryEmpty() || waitFull && cmMob.getIsInventoryFull())) {
                            cmMob.setIsBeingStationed(false);
                            cmMob.setLastStationLeft(mobObject.getWorldEntity().getTime());
                            mobObject.minecartSpeed = Math.min(cmMob.MAX_SPEED, mobObject.minecartSpeed + cmMob.BOOST_SPEED * inventoryAccelerationMod * delta / 30.0f * mobObject.getAccelerationModifier());
                            cmMob.sendMovementPacket(true);
                            if (((StationTrackObject)trackObject).isPowered(mobObject.getLevel(), tileX, tileY)) {
                                if (mobObject.getDir() == 3) {
                                    mobObject.setFacingDir(1.0f, 0.0f);
                                    mobObject.minecartDir = mobObject.getDir();
                                } else if (mobObject.getDir() == 2) {
                                    mobObject.setFacingDir(0.0f, -1.0f);
                                    mobObject.minecartDir = mobObject.getDir();
                                } else if (mobObject.getDir() == 1) {
                                    mobObject.setFacingDir(-1.0f, 0.0f);
                                    mobObject.minecartDir = mobObject.getDir();
                                } else {
                                    mobObject.setFacingDir(0.0f, 1.0f);
                                    mobObject.minecartDir = mobObject.getDir();
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}

