/*
 * Decompiled with CFR 0.152.
 */
package hardenedSettlements.leveldata;

import hardenedSettlements.SettlementData;
import java.util.HashMap;
import java.util.Map;
import necesse.engine.save.LoadData;
import necesse.engine.save.SaveData;
import necesse.engine.world.WorldEntity;
import necesse.engine.world.worldData.WorldData;

public class HardenedSettlementsWorldData
extends WorldData {
    public Map<Integer, SettlementData> settlementIdToDataMap = new HashMap<Integer, SettlementData>();

    public void addSaveData(SaveData save) {
        super.addSaveData(save);
        SaveData settlementsSaveData = new SaveData("SETTLEMENTS");
        this.settlementIdToDataMap.forEach((settlementId, settlementData) -> {
            SaveData settlementSaveData = new SaveData("SETTLEMENT");
            settlementSaveData.addInt("uniqueID", settlementId.intValue());
            settlementData.addSaveData(settlementSaveData);
            settlementsSaveData.addSaveData(settlementSaveData);
        });
        save.addSaveData(settlementsSaveData);
    }

    public void applyLoadData(LoadData save) {
        super.applyLoadData(save);
        this.settlementIdToDataMap = new HashMap<Integer, SettlementData>();
        LoadData settlementsLoadData = save.getFirstLoadDataByName("SETTLEMENTS");
        settlementsLoadData.getLoadData().forEach(settlementLoadData -> {
            int settlementID = settlementLoadData.getInt("uniqueID");
            SettlementData settlementData = SettlementData.fromLoadData(settlementLoadData);
            this.settlementIdToDataMap.put(settlementID, settlementData);
        });
    }

    public SettlementData getDataForSettlementID(int settlementID) {
        return this.settlementIdToDataMap.computeIfAbsent(settlementID, id -> new SettlementData());
    }

    public static HardenedSettlementsWorldData getDataCreateIfNoneExist(WorldEntity worldEntity) {
        HardenedSettlementsWorldData worldData = HardenedSettlementsWorldData.getData(worldEntity);
        if (worldData == null) {
            worldData = new HardenedSettlementsWorldData();
            worldEntity.addWorldData("hardenedsettlements", (WorldData)worldData);
        }
        return worldData;
    }

    public static HardenedSettlementsWorldData getData(WorldEntity worldEntity) {
        WorldData data = worldEntity.getWorldData("hardenedsettlements");
        return data instanceof HardenedSettlementsWorldData ? (HardenedSettlementsWorldData)data : null;
    }
}

