/*
 * Decompiled with CFR 0.152.
 */
package lightOverlay.patch;

import java.util.List;
import lightOverlay.LightOverlay;
import lightOverlay.OverlayDrawable;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.modLoader.annotations.ModMethodPatch;
import necesse.engine.modifiers.Modifier;
import necesse.entity.mobs.MobSpawnLocation;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.BuffModifiers;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.texture.SharedTextureDrawOptions;
import necesse.gfx.drawables.Drawable;
import necesse.gfx.drawables.LevelDrawUtils;
import necesse.gfx.drawables.LevelTileDamageDrawOptions;
import necesse.gfx.drawables.LevelTileLightDrawOptions;
import necesse.gfx.drawables.LevelTileLiquidDrawOptions;
import necesse.gfx.drawables.LevelTileTerrainDrawOptions;
import necesse.gfx.drawables.OrderableDrawables;
import necesse.level.maps.Level;
import net.bytebuddy.asm.Advice;

public class LevelDrawUtilsPatch {

    @ModMethodPatch(target=LevelDrawUtils.class, name="addTileBasedDrawProcesses", arguments={TickManager.class, GameCamera.class, LevelDrawUtils.DrawArea.class, LevelDrawUtils.DrawArea.class, LevelTileTerrainDrawOptions.class, LevelTileLiquidDrawOptions.class, LevelTileTerrainDrawOptions.class, LevelTileDamageDrawOptions.class, LevelTileLightDrawOptions.class, SharedTextureDrawOptions.class, SharedTextureDrawOptions.class, OrderableDrawables.class, List.class, boolean.class, PlayerMob.class})
    public static class AddTileBasedDrawProcessesPatch {
        @Advice.OnMethodExit
        static void onExit(@Advice.FieldValue(value="level") Level level, @Advice.Argument(value=1) GameCamera camera, @Advice.Argument(value=2) LevelDrawUtils.DrawArea tileArea, @Advice.Argument(value=11) OrderableDrawables list) {
            if (!LightOverlay.settings.drawOverlay || level.lightManager.ambientLightOverride != null) {
                return;
            }
            LightOverlay.fakeHostileMob.setLevel(level);
            Modifier modifier = BuffModifiers.MOB_SPAWN_LIGHT_THRESHOLD;
            int threshold = (Integer)LightOverlay.fakeHostileMob.spawnLightThreshold.limits.applyModifierLimits(modifier, (Object)((Integer)modifier.finalLimit((Object)((Integer)modifier.appendManager((Object)((Integer)modifier.defaultBuffManagerValue), (Object)((Integer)LightOverlay.fakeHostileMob.spawnLightThreshold.value))))));
            for (int tileX = tileArea.startTileX; tileX <= tileArea.endTileX; ++tileX) {
                for (int tileY = tileArea.startTileY; tileY <= tileArea.endTileY; ++tileY) {
                    boolean canSpawn = new MobSpawnLocation(LightOverlay.fakeHostileMob, tileX * 32 + 16, tileY * 32 + 16).checkMaxStaticLightThreshold(threshold).checkMobSpawnLocation().validAndApply();
                    if (!canSpawn) continue;
                    list.add((Drawable)new OverlayDrawable(tileX, tileY, camera));
                }
            }
        }
    }
}

