/*
 * Decompiled with CFR 0.152.
 */
package lightOverlay;

import lightOverlay.Settings;
import lightOverlay.command.ModifyOverlayAlphaCommand;
import necesse.engine.GlobalData;
import necesse.engine.commands.ChatCommand;
import necesse.engine.commands.CommandsManager;
import necesse.engine.commands.PermissionLevel;
import necesse.engine.commands.clientCommands.BoolClientCommand;
import necesse.engine.input.Control;
import necesse.engine.input.InputEvent;
import necesse.engine.localization.Localization;
import necesse.engine.modLoader.annotations.ModEntry;
import necesse.engine.state.MainGame;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.hostile.ZombieMob;
import necesse.gfx.gameTexture.GameTexture;

@ModEntry
public class LightOverlay {
    public static GameTexture lowLightTexture;
    public static Mob fakeHostileMob;
    public static Control toggleOverlayControl;
    public static Settings settings;

    public void init() {
        fakeHostileMob = new ZombieMob();
        toggleOverlayControl = Control.addModControl((Control)new Control(297, "toggleoverlay"){

            public void activate(InputEvent event) {
                super.activate(event);
                if (this.isPressed()) {
                    MainGame mainGame;
                    LightOverlay.settings.drawOverlay = !LightOverlay.settings.drawOverlay;
                    MainGame mainGame2 = mainGame = GlobalData.getCurrentState() instanceof MainGame ? (MainGame)GlobalData.getCurrentState() : null;
                    if (mainGame != null) {
                        mainGame.getClient().chat.addMessage(Localization.translate((String)"controls", (String)"togglemessage") + " " + Localization.translate((String)"controls", (String)(LightOverlay.settings.drawOverlay ? "on" : "off")));
                    }
                }
            }
        });
    }

    public void initResources() {
        lowLightTexture = GameTexture.fromFile((String)"texture/lowlight");
    }

    public Settings initSettings() {
        settings = new Settings();
        return settings;
    }

    public void postInit() {
        try {
            CommandsManager.registerClientCommand((ChatCommand)new BoolClientCommand("lightoverlay", "Toggle light overlay", PermissionLevel.USER, Settings.class.getField("drawOverlay"), (Object)settings));
        }
        catch (NoSuchFieldException | SecurityException e) {
            System.out.println("Could not register lightoverlay command: " + e.getMessage());
            e.printStackTrace();
        }
        CommandsManager.registerClientCommand((ChatCommand)new ModifyOverlayAlphaCommand());
    }
}

