/*
 * Decompiled with CFR 0.152.
 */
package travelKeybinds;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import necesse.engine.GlobalData;
import necesse.engine.input.Control;
import necesse.engine.input.InputEvent;
import necesse.engine.localization.Localization;
import necesse.engine.modLoader.annotations.ModEntry;
import necesse.engine.network.client.Client;
import necesse.engine.registries.ItemRegistry;
import necesse.engine.state.MainGame;
import necesse.inventory.PlayerInventoryManager;
import necesse.inventory.PlayerInventorySlot;

@ModEntry
public class TravelKeybinds {
    public static Control recallControl;
    public static Control travelControl;
    private static Set<Integer> recallItemIds;
    private static Set<Integer> travelItemIds;

    public void init() {
        recallItemIds = new HashSet<Integer>();
        recallItemIds.add(ItemRegistry.getItemID((String)"recallscroll"));
        recallItemIds.add(ItemRegistry.getItemID((String)"recallflask"));
        travelItemIds = new HashSet<Integer>();
        travelItemIds.add(ItemRegistry.getItemID((String)"teleportationscroll"));
        recallControl = Control.addModControl((Control)new Control(-1, "recall"){

            public void activate(InputEvent event) {
                super.activate(event);
                if (this.isPressed()) {
                    TravelKeybinds.recall(((MainGame)GlobalData.getCurrentState()).getClient());
                }
            }
        });
        travelControl = Control.addModControl((Control)new Control(-1, "travel"){

            public void activate(InputEvent event) {
                super.activate(event);
                if (this.isPressed()) {
                    TravelKeybinds.travel(((MainGame)GlobalData.getCurrentState()).getClient());
                }
            }
        });
    }

    private static void recall(Client client) {
        if (client.getPlayer() == null) {
            return;
        }
        PlayerInventoryManager invManager = client.getPlayer().getInv();
        Optional<PlayerInventorySlot> recallSlot = invManager.streamPlayerSlots(false, true, true, true).filter(new ItemIdSearch(invManager, recallItemIds)).findFirst();
        if (recallSlot.isPresent()) {
            client.getPlayer().tryAttack(recallSlot.get(), 0, 0);
        } else {
            client.chat.addMessage(Localization.translate((String)"chat", (String)"norecallitems"));
        }
    }

    private static void travel(Client client) {
        if (client.getPlayer() == null) {
            return;
        }
        PlayerInventoryManager invManager = client.getPlayer().getInv();
        Optional<PlayerInventorySlot> travelSlot = invManager.streamPlayerSlots(false, true, true, true).filter(new ItemIdSearch(invManager, travelItemIds)).findFirst();
        if (travelSlot.isPresent()) {
            client.getPlayer().tryAttack(travelSlot.get(), 0, 0);
        } else {
            client.chat.addMessage(Localization.translate((String)"chat", (String)"notravelitems"));
        }
    }

    private static class ItemIdSearch
    implements Predicate<PlayerInventorySlot> {
        private final PlayerInventoryManager invManager;
        private final Set<Integer> itemIds;

        private ItemIdSearch(PlayerInventoryManager invManager, Set<Integer> itemIds) {
            this.invManager = invManager;
            this.itemIds = itemIds;
        }

        @Override
        public boolean test(PlayerInventorySlot slot) {
            if (slot.isSlotClear(this.invManager)) {
                return false;
            }
            return this.itemIds.contains(slot.getItem((PlayerInventoryManager)this.invManager).item.getID());
        }
    }
}

