/*
 * Decompiled with CFR 0.152.
 */
package com.jubiman.mmt.patch;

import com.jubiman.mmt.MoreMergedTrinkets;
import java.awt.Color;
import necesse.engine.localization.Localization;
import necesse.engine.modLoader.annotations.ModMethodPatch;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.engine.state.MainGame;
import necesse.entity.mobs.PlayerMob;
import necesse.gfx.GameResources;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.gameFont.FontOptions;
import necesse.level.maps.hudManager.HudDrawElement;
import necesse.level.maps.hudManager.floatText.UniqueFloatText;
import net.bytebuddy.asm.Advice;

@ModMethodPatch(target=PlayerMob.class, name="tickControls", arguments={MainGame.class, boolean.class, GameCamera.class})
public class PlayerControlPatch {
    public static boolean isToggled = false;

    @Advice.OnMethodExit
    static void onTickControls(@Advice.This PlayerMob playerMob, @Advice.Argument(value=0) MainGame mainGame, @Advice.Argument(value=1) boolean isGameTick, @Advice.Argument(value=2) GameCamera gameCamera) {
        if (MoreMergedTrinkets.TOGGLE_MMT_BUFFS.isPressed()) {
            Color color = isToggled ? new Color(100, 200, 100) : new Color(200, 100, 100);
            ToggleFloatText text = new ToggleFloatText(playerMob.getX(), playerMob.getY() - 20, Localization.translate((String)"misc", (String)(isToggled ? "mmt_buffson" : "mmt_buffsoff")), new FontOptions(16).outline().color(color), "mmt_toggle_buffs");
            text.riseTime = 500;
            text.fadeTime = 500;
            text.expandTime = 50;
            playerMob.getLevel().hudManager.addElement((HudDrawElement)text);
            SoundManager.playSound((GameSound)GameResources.tick, (SoundEffect)SoundEffect.ui());
            isToggled = !isToggled;
        }
    }

    public static class ToggleFloatText
    extends UniqueFloatText {
        private final int x;
        private final int y;

        public ToggleFloatText(int x, int y, String text, FontOptions fontOptions, String id) {
            super(x, y, text, fontOptions, id);
            this.x = x;
            this.y = y;
        }

        public int getAnchorX() {
            return this.x;
        }

        public int getAnchorY() {
            return this.y;
        }
    }
}

