/*
 * Decompiled with CFR 0.152.
 */
package com.jubiman.mmt.buff;

import java.util.Objects;
import necesse.engine.localization.Localization;
import necesse.engine.util.GameRandom;
import necesse.entity.mobs.MobBeforeHitEvent;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.buffs.BuffEventSubscriber;
import necesse.entity.mobs.buffs.BuffModifiers;
import necesse.entity.mobs.buffs.staticBuffs.armorBuffs.trinketBuffs.TrinketBuff;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.trinketItem.TrinketItem;
import necesse.inventory.lootTable.LootItemInterface;
import necesse.inventory.lootTable.lootItem.LootItem;

public class GamblersBlessingBuff
extends TrinketBuff {
    public void init(ActiveBuff activeBuff, BuffEventSubscriber buffEventSubscriber) {
        activeBuff.setModifier(BuffModifiers.CRIT_CHANCE, (Object)Float.valueOf(0.5f));
    }

    public void onBeforeAttacked(ActiveBuff buff, MobBeforeHitEvent hitEvent) {
        super.onBeforeAttacked(buff, hitEvent);
        if (!hitEvent.isPrevented()) {
            LootItemInterface lastItem;
            if (GameRandom.globalRandom.nextFloat() < 0.01f) {
                hitEvent.damage = hitEvent.damage.modFinalMultiplier(7.0f);
            }
            LootItemInterface lootItemInterface = lastItem = !hitEvent.target.getLootTable().items.isEmpty() ? (LootItemInterface)hitEvent.target.getLootTable().items.get(hitEvent.target.getLootTable().items.size() - 1) : null;
            if (lastItem == null) {
                return;
            }
            if (!(lastItem instanceof LootItem) || !Objects.equals(((LootItem)lastItem).itemStringID, "coin")) {
                hitEvent.target.getLootTable().items.add(new LootItem("coin", GameRandom.globalRandom.nextInt(7)));
            }
        }
    }

    public ListGameTooltips getTrinketTooltip(TrinketItem trinketItem, InventoryItem item, PlayerMob perspective) {
        ListGameTooltips tooltips = super.getTrinketTooltip(trinketItem, item, perspective);
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"mmt_gamblersblessing1"));
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"mmt_gamblersblessing2"));
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"mmt_gamblersblessing3"));
        return tooltips;
    }
}

