/*
 * Decompiled with CFR 0.152.
 */
package com.jubiman.mmt.buff;

import java.awt.Color;
import java.awt.geom.Point2D;
import necesse.engine.localization.Localization;
import necesse.engine.registries.BuffRegistry;
import necesse.engine.util.GameRandom;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.MobBeforeHitEvent;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.buffs.BuffModifiers;
import necesse.entity.mobs.buffs.staticBuffs.armorBuffs.trinketBuffs.OutOfCombatBuff;
import necesse.entity.particle.Particle;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.trinketItem.TrinketItem;
import necesse.level.gameTile.GameTile;
import necesse.level.gameTile.LiquidTile;

public class ArcticExplorersEquipmentBuff
extends OutOfCombatBuff {
    public static void tooltips(ListGameTooltips tooltips) {
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"mmt_arcticexplorersequipment1"));
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"mmt_arcticexplorersequipment2"));
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"mmt_arcticexplorersequipment3"));
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"mmt_arcticexplorersequipment4"));
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"mmt_arcticexplorersequipment5"));
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"mmt_arcticexplorersequipment6"));
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"mmt_arcticexplorersequipment7"));
    }

    public void tickEffect(ActiveBuff buff, Mob owner) {
        if (this.isActive(buff) && (owner.dx != 0.0f || owner.dy != 0.0f)) {
            Color color;
            if (owner.inLiquid()) {
                GameTile tile = owner.getLevel().getTile(owner.getX() / 32, owner.getY() / 32);
                color = tile.isLiquid ? ((LiquidTile)tile).getLiquidColor(owner.getLevel(), owner.getX() / 32, owner.getY() / 32).brighter() : new Color(89, 139, 224);
            } else {
                color = new Color(65, 30, 109);
            }
            boolean next = buff.getGndData().getBoolean("pAlt");
            buff.getGndData().setBoolean("pAlt", !next);
            Point2D.Float pos = owner.getDir() == 0 || owner.getDir() == 2 ? new Point2D.Float(owner.x + (float)(next ? -4 : 4), owner.y) : new Point2D.Float(owner.x, owner.y + (float)(next ? -4 : 4));
            owner.getLevel().entityManager.addParticle(pos.x + (float)(GameRandom.globalRandom.nextGaussian() * 2.0), pos.y + (float)(GameRandom.globalRandom.nextGaussian() * 2.0), Particle.GType.IMPORTANT_COSMETIC).color(color).sizeFades(10, 12).movesConstant(owner.dx / 10.0f, owner.dy / 10.0f).lifeTime(300).height(0.0f);
        }
    }

    protected void updateActive(ActiveBuff activeBuff, boolean active) {
        activeBuff.setModifier(BuffModifiers.SPEED, (Object)Float.valueOf(0.35f));
        activeBuff.setModifier(BuffModifiers.ATTACK_SPEED, (Object)Float.valueOf(0.1f));
        activeBuff.setModifier(BuffModifiers.KNOCKBACK_INCOMING_MOD, (Object)Float.valueOf(0.0f));
        activeBuff.setMinModifier(BuffModifiers.FRICTION, (Object)Float.valueOf(1.0f));
        activeBuff.setModifier(BuffModifiers.TRAVEL_DISTANCE, (Object)1);
        activeBuff.setModifier(BuffModifiers.BIOME_VIEW_DISTANCE, (Object)1);
        if (active) {
            activeBuff.setModifier(BuffModifiers.SPEED_FLAT, (Object)Float.valueOf(5.0f));
            activeBuff.setModifier(BuffModifiers.SWIM_SPEED, (Object)Float.valueOf(1.0f));
        }
    }

    public void onBeforeAttacked(ActiveBuff buff, MobBeforeHitEvent event) {
        super.onBeforeAttacked(buff, event);
        if (!event.isPrevented()) {
            event.target.buffManager.addBuff(new ActiveBuff(BuffRegistry.Debuffs.CHILLED, event.target, 2.0f, event.attacker), event.target.getLevel().isServer());
        }
    }

    public ListGameTooltips getTrinketTooltip(TrinketItem trinketItem, InventoryItem item, PlayerMob perspective) {
        ListGameTooltips tooltips = super.getTrinketTooltip(trinketItem, item, perspective);
        ArcticExplorersEquipmentBuff.tooltips(tooltips);
        return tooltips;
    }
}

