/*
 * Decompiled with CFR 0.152.
 */
package magicalcrops.items;

import java.awt.Color;
import java.util.Arrays;
import java.util.stream.Collectors;
import necesse.engine.registries.ItemRegistry;
import necesse.engine.registries.RecipeTechRegistry;
import necesse.gfx.gameTexture.GameTexture;
import necesse.inventory.item.Item;
import necesse.inventory.item.matItem.MatItem;
import necesse.inventory.recipe.Recipe;
import necesse.inventory.recipe.Recipes;
import necesse.inventory.recipe.Tech;
import necesse.level.gameObject.SeedObject;

public class MagicalCrops
extends MatItem {
    protected String cropTextureName;
    public String seedType;
    public String resources;
    public String crop;
    public int tier;
    public Tech tech;
    public String outputResources;

    public MagicalCrops(int stackSize, Item.Rarity rarity, String resources, String outputResources, String crop, String seedType, int tier, Tech tech) {
        super(stackSize, rarity, new String[0]);
        this.seedType = seedType;
        this.crop = crop;
        this.outputResources = outputResources;
        this.resources = resources;
        this.tier = tier;
        this.tech = tech;
    }

    protected void loadItemTextures() {
        if (this.cropTextureName != null) {
            this.itemTexture = new GameTexture(GameTexture.fromFile((String)("objects/" + this.cropTextureName)), 0, 0, 32);
        } else {
            super.loadItemTextures();
        }
    }

    public MagicalCrops cropTexture(String textureName) {
        this.cropTextureName = textureName;
        return this;
    }

    public void doInit() {
        this.registerCrop();
        this.registerItem();
    }

    public void doPostInit() {
        this.registerModRecipes();
    }

    public void registerCrop() {
        SeedObject.registerSeedObjects((String)this.getSeedLocale(), (String)this.getCropLocale(), (String)this.getEssenceLocale(), (int)1, (int)0, (int)5, (float)4200.0f, (float)6000.0f, (Color)new Color(90, 61, 48), (float)1.0f);
    }

    public void registerItem() {
        ItemRegistry.registerItem((String)this.getEssenceLocale(), (Item)this.cropTexture(this.getCropLocale()).addGlobalIngredient(new String[]{"anycompostable"}), (float)1.0f, (boolean)true);
    }

    public void registerModRecipes() {
        this.registerEssenceRecipe();
        this.registerSeedRecipe();
    }

    public void registerEssenceRecipe() {
        block6: {
            block5: {
                if (this.resources == null) {
                    return;
                }
                if (!this.seedType.equals("resource") && !this.seedType.equals("any")) break block5;
                if (this.outputResources == null) {
                    return;
                }
                for (String outputResource : this.outputResources.split(",")) {
                    String[] parts;
                    if (outputResource.startsWith("custom")) {
                        parts = outputResource.replaceFirst("custom:", "").split("=");
                        String input = parts[0];
                        String output = parts[1];
                        String[] inputParts = input.split("\\+");
                        String[] outputParts = output.split(":");
                        String ingredients = String.format("{%s}", Arrays.stream(inputParts).map(s -> {
                            String[] part = s.split(":");
                            return String.format("{%s, %s}", part[0], part[1]);
                        }).collect(Collectors.joining(", ")));
                        Recipes.registerModRecipe((Recipe)new Recipe(outputParts[0], Integer.parseInt(outputParts[1]), this.seedType.equals("any") ? RecipeTechRegistry.WORKSTATION : RecipeTechRegistry.FORGE, Recipes.ingredientsFromScript((String)ingredients)));
                        continue;
                    }
                    parts = outputResource.split(":");
                    Recipes.registerModRecipe((Recipe)new Recipe(parts[0], 1, this.seedType.equals("any") ? RecipeTechRegistry.WORKSTATION : RecipeTechRegistry.FORGE, Recipes.ingredientsFromScript((String)String.format("{{%s, %s}}", this.getEssenceLocale(), parts.length > 1 ? parts[1] : Integer.valueOf(4)))));
                }
                break block6;
            }
            if (!this.seedType.equals("essence")) break block6;
            for (String resource : this.resources.split(",")) {
                String[] parts = resource.split(":");
                Recipes.registerModRecipe((Recipe)new Recipe(this.getEssenceLocale(), 1, this.tech, Recipes.ingredientsFromScript((String)String.format("{{%s, 8}, {%s, %s}}", this.getPreviousTierEssenceLocale(), parts[0], parts.length > 1 ? parts[1] : Integer.valueOf(4)))));
            }
        }
    }

    public void registerSeedRecipe() {
        if (this.seedType.equals("resource") || this.seedType.equals("any")) {
            if (this.resources == null) {
                return;
            }
            String formatted = Arrays.stream(this.resources.split(",")).map(s -> {
                String[] parts = s.split(":");
                return String.format("{%s, %s}", parts[0], parts.length > 1 ? parts[1] : Integer.valueOf(4));
            }).collect(Collectors.joining(", "));
            Recipes.registerModRecipe((Recipe)new Recipe(this.getSeedLocale(), 1, this.tech, Recipes.ingredientsFromScript((String)String.format("{{%s, 4}, {%s, 1}, %s}", this.getTierEssenceLocale(), this.getTierSeedLocale(), formatted))));
        } else if (this.seedType.equals("essence")) {
            Recipes.registerModRecipe((Recipe)new Recipe(this.getSeedLocale(), 1, this.tech, Recipes.ingredientsFromScript((String)String.format("{{%s, 8}, {%s, 1}}", this.getEssenceLocale(), this.getPreviousTierSeedLocale()))));
        }
    }

    public String getEssenceLocale() {
        return String.format("kew_%s_essence", this.crop);
    }

    public String getSeedLocale() {
        return String.format("kew_%s_seed", this.crop);
    }

    public String getCropLocale() {
        return String.format("kew_%s_crop", this.crop);
    }

    public String getTierSeedLocale() {
        return String.format("kew_tier_%s_seed", this.tier);
    }

    public String getTierEssenceLocale() {
        return String.format("kew_tier_%s_essence", this.tier);
    }

    public String getPreviousTierSeedLocale() {
        if (this.tier == 1) {
            return "grassseed";
        }
        return String.format("kew_tier_%s_seed", this.tier - 1);
    }

    public String getPreviousTierEssenceLocale() {
        return String.format("kew_tier_%s_essence", this.tier - 1);
    }
}

