/*
 * Decompiled with CFR 0.152.
 */
package magicalcrops;

import java.util.ArrayList;
import magicalcrops.items.MagicalCrops;
import necesse.engine.modLoader.annotations.ModEntry;
import necesse.engine.registries.RecipeTechRegistry;
import necesse.inventory.item.Item;
import necesse.inventory.recipe.Tech;

@ModEntry
public class Main {
    public ArrayList<MagicalCrops> magicalCrops = new ArrayList();

    public void init() {
        this.addCrop("tier_1", 1, null, null);
        this.addCrop("tier_2", 2, "copperbar,ironbar,goldbar", null);
        this.addCrop("tier_3", 3, "demonicbar,ivybar,frostshard,quartz", null);
        this.addCrop("tier_4", 4, "ancientfossilbar,myceliumbar,glacialbar,tungstenbar,obsidian,slimeum,spideritebar,lifequartz", null);
        this.addCrop("tier_5", 5, "emerald,ruby,sapphire,amethyst,alchemyshard,nightsteelbar,omnicrystal,pearlescentdiamond", null);
        this.addCrop("fire", 1, "lavatile", "custom:bucket:1+kew_fire_essence:8=lavatile:1");
        this.addCrop("water", 1, "watertile", "custom:bucket:1+kew_water_essence:8=watertile:1");
        this.addCrop("wood", 1, "anylog", "oaklog,sprucelog,pinelog,palmlog,willowlog,birchlog,maplelog");
        this.addCrop("stone", 1, "stone", "stone");
        this.addCrop("copper", 2);
        this.addCrop("iron", 2);
        this.addCrop("gold", 2);
        this.addCrop("ivy", 3);
        this.addCrop("demonic", 3, "demonicbar", "demonicbar:16");
        this.addCrop("frostshard", 3, "frostshard", "frostshard:16");
        this.addCrop("quartz", 3, "quartz", "quartz");
        this.addCrop("mycelium", 4, "myceliumbar", "myceliumore:16");
        this.addCrop("ancientfossil", 4);
        this.addCrop("glacial", 4);
        this.addCrop("tungsten", 4);
        this.addCrop("obsidian", 4, "obsidian", "obsidian:16");
        this.addCrop("slimeum", 4, "slimeum", "slimeum:16");
        this.addCrop("spiderite", 4);
        this.addCrop("lifequartz", 4, "lifequartz", "lifequartz:16");
        this.addCrop("nightsteel", 5);
        this.addCrop("alchemyshard", 5, "alchemyshard", "alchemyshard:8");
        this.addCrop("amethyst", 5, "amethyst", "amethyst:16");
        this.addCrop("ruby", 5, "ruby", "ruby:16");
        this.addCrop("emerald", 5, "emerald", "emerald:16");
        this.addCrop("sapphire", 5, "sapphire", "sapphire:16");
        this.addCrop("pearlescentdiamond", 5, "pearlescentdiamond", "pearlescentdiamond:16");
        for (MagicalCrops crop : this.magicalCrops) {
            crop.doInit();
        }
    }

    public void addCrop(String crop, int tier, String resources, String outputResources) {
        Tech tech = this.techFromTier(tier);
        Item.Rarity rarity = this.rarityFromTier(tier);
        this.magicalCrops.add(new MagicalCrops(1000, rarity, resources, outputResources, crop, this.seedTypeFromCrop(crop), tier, tech));
    }

    public void addCrop(String crop, int tier) {
        Tech tech = this.techFromTier(tier);
        Item.Rarity rarity = this.rarityFromTier(tier);
        this.magicalCrops.add(new MagicalCrops(1000, rarity, String.format("%sbar", crop), String.format("%sore", crop), crop, this.seedTypeFromCrop(crop), tier, tech));
    }

    public Tech techFromTier(int tier) {
        switch (tier) {
            case 1: {
                return RecipeTechRegistry.WORKSTATION;
            }
            case 2: {
                return RecipeTechRegistry.WORKSTATION;
            }
            case 3: {
                return RecipeTechRegistry.DEMONIC_WORKSTATION;
            }
            case 4: {
                return RecipeTechRegistry.TUNGSTEN_WORKSTATION;
            }
            case 5: {
                return RecipeTechRegistry.FALLEN_WORKSTATION;
            }
        }
        return null;
    }

    public Item.Rarity rarityFromTier(int tier) {
        switch (tier) {
            case 1: {
                return Item.Rarity.NORMAL;
            }
            case 2: {
                return Item.Rarity.COMMON;
            }
            case 3: {
                return Item.Rarity.UNCOMMON;
            }
            case 4: {
                return Item.Rarity.RARE;
            }
            case 5: {
                return Item.Rarity.EPIC;
            }
        }
        return null;
    }

    public String seedTypeFromCrop(String crop) {
        if (crop.contains("tier_")) {
            return "essence";
        }
        if ("wood,stone,fire,water".contains(crop)) {
            return "any";
        }
        return "resource";
    }

    public void postInit() {
        for (MagicalCrops crop : this.magicalCrops) {
            crop.doPostInit();
        }
    }
}

