/*
 * Decompiled with CFR 0.152.
 */
package DefenseTower.projectiles;

import DefenseTower.gameObject.DefenseTowerExtraObject;
import java.util.List;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.entity.Entity;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.projectile.Projectile;
import necesse.gfx.GameResources;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.texture.TextureDrawOptions;
import necesse.gfx.drawOptions.texture.TextureDrawOptionsEnd;
import necesse.gfx.drawables.EntityDrawable;
import necesse.gfx.drawables.LevelSortedDrawable;
import necesse.gfx.drawables.OrderableDrawables;
import necesse.level.gameObject.DoorObject;
import necesse.level.gameObject.FenceObject;
import necesse.level.gameObject.GameObject;
import necesse.level.gameObject.WallObject;
import necesse.level.maps.CollisionFilter;
import necesse.level.maps.Level;
import necesse.level.maps.light.GameLight;

public class DTProjectile
extends Projectile {
    public void init() {
        super.init();
        this.height = 64.0f;
        this.heightBasedOnDistance = true;
        this.setWidth(8.0f);
    }

    public void addDrawables(List<LevelSortedDrawable> list, OrderableDrawables orderableDrawables, OrderableDrawables orderableDrawables1, OrderableDrawables orderableDrawables2, Level level, TickManager tickManager, GameCamera gameCamera, PlayerMob playerMob) {
        if (!this.removed()) {
            GameLight light = level.getLightLevel((Entity)this);
            int drawX = gameCamera.getDrawX(this.x) - this.texture.getWidth() / 2;
            int drawY = gameCamera.getDrawY(this.y);
            TextureDrawOptionsEnd options = this.texture.initDraw().light(light).rotate(this.getAngle(), this.texture.getWidth() / 2, 0).pos(drawX, drawY - (int)this.getHeight());
            list.add((LevelSortedDrawable)new EntityDrawable((Entity)this, (TextureDrawOptions)options){
                final /* synthetic */ TextureDrawOptions val$options;
                {
                    this.val$options = textureDrawOptions;
                    super(arg0);
                }

                public void draw(TickManager tickManager) {
                    this.val$options.draw();
                }
            });
            this.addShadowDrawables(orderableDrawables, drawX, drawY, light, this.getAngle(), 0);
        }
    }

    public boolean canHit(Mob mob) {
        return mob.isHostile;
    }

    protected CollisionFilter getLevelCollisionFilter() {
        CollisionFilter filter = super.getLevelCollisionFilter();
        filter.addFilter(tp -> {
            GameObject object = tp.object().object;
            return !(object instanceof DefenseTowerExtraObject) && !(object instanceof WallObject) && !(object instanceof FenceObject) && !(object instanceof DoorObject);
        });
        return filter;
    }

    public void dropItem() {
    }

    protected void playHitSound(float x, float y) {
        SoundManager.playSound((GameSound)GameResources.bowhit, (SoundEffect)SoundEffect.effect((float)x, (float)y));
    }
}

