/*
 * Decompiled with CFR 0.152.
 */
package DefenseTower.projectiles;

import DefenseTower.events.DefenseTowerExplosionEvent;
import DefenseTower.projectiles.DTProjectile;
import java.awt.Color;
import necesse.entity.levelEvent.LevelEvent;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.Mob;
import necesse.entity.projectile.Projectile;
import necesse.entity.trails.Trail;
import necesse.level.maps.LevelObjectHit;

public class DTCannonBallProjectile
extends DTProjectile {
    private long spawnTime;

    public DTCannonBallProjectile() {
    }

    public DTCannonBallProjectile(float x, float y, float targetX, float targetY, int speed, int distance, GameDamage damage, int knockback, Mob owner) {
        this();
        this.setLevel(owner.getLevel());
        this.applyData(x, y, targetX, targetY, speed, distance, damage, knockback, owner);
    }

    @Override
    public void init() {
        super.init();
        this.setWidth(15.0f);
        this.spawnTime = this.getWorldEntity().getTime();
        this.doesImpactDamage = false;
        this.trailOffset = 0.0f;
    }

    public Trail getTrail() {
        return new Trail((Projectile)this, this.getLevel(), new Color(30, 30, 30), 14.0f, 250, this.getHeight());
    }

    public float getAngle() {
        return this.getWorldEntity().getTime() - this.spawnTime;
    }

    public void doHitLogic(Mob mob, LevelObjectHit objectHit, float x, float y) {
        if (this.getLevel().isServer()) {
            DefenseTowerExplosionEvent event = new DefenseTowerExplosionEvent(x, y, this.getDamage(), this.getOwner());
            this.getLevel().entityManager.addLevelEvent((LevelEvent)event);
        }
    }

    @Override
    protected void playHitSound(float x, float y) {
    }
}

