/*
 * Decompiled with CFR 0.152.
 */
package DefenseTower.objectEntity;

import java.awt.Color;
import java.awt.Rectangle;
import java.util.List;
import necesse.engine.GameTileRange;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.input.Control;
import necesse.engine.localization.Localization;
import necesse.engine.localization.message.GameMessage;
import necesse.engine.localization.message.LocalMessage;
import necesse.engine.registries.ProjectileRegistry;
import necesse.engine.util.gameAreaSearch.GameAreaStream;
import necesse.engine.window.GameWindow;
import necesse.engine.window.WindowManager;
import necesse.entity.Entity;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.DeathMessageTable;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.objectEntity.ObjectEntity;
import necesse.entity.projectile.Projectile;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.texture.SharedTextureDrawOptions;
import necesse.gfx.drawables.SortedDrawable;
import necesse.gfx.gameTooltips.GameTooltipManager;
import necesse.gfx.gameTooltips.GameTooltips;
import necesse.gfx.gameTooltips.StringTooltips;
import necesse.gfx.gameTooltips.TooltipLocation;
import necesse.level.maps.Level;
import necesse.level.maps.hudManager.HudDrawElement;
import necesse.level.maps.multiTile.MultiTile;

public class DefenseTowerEntity
extends ObjectEntity
implements Attacker {
    private final long cooldown;
    private final int attackDistance;
    private final int searchDistance;
    private final float damage;
    private final String projectileStringID;
    private final GameTileRange range;
    private final Mob attacker;
    private final boolean targetBoss;
    private final GameWindow gameWindow;
    private HudDrawElement rangeElement;
    private boolean showRange = false;
    private long cooldownTime = 0L;

    public DefenseTowerEntity(Level level, String type, int x, int y, String projectileStringID, int attackDistance, float damage, long cooldown, PlayerMob owner, boolean targetBoss) {
        super(level, type, x, y);
        this.projectileStringID = targetBoss ? projectileStringID.replace("_boss", "") : projectileStringID;
        this.attackDistance = attackDistance;
        this.searchDistance = attackDistance - 32;
        this.damage = damage;
        this.cooldown = cooldown;
        this.targetBoss = targetBoss;
        this.gameWindow = WindowManager.getWindow();
        this.attacker = owner;
        MultiTile multiTile = this.getObject().getMultiTile(0);
        Rectangle tileRectangle = multiTile.getTileRectangle(0, 0);
        this.range = new GameTileRange(this.searchDistance / 32 - 1, tileRectangle);
    }

    public void init() {
        super.init();
        if (this.rangeElement != null) {
            this.rangeElement.remove();
        }
        this.rangeElement = new HudDrawElement(){

            public void addDrawables(List<SortedDrawable> list, GameCamera gameCamera, PlayerMob playerMob) {
                SharedTextureDrawOptions options;
                if (DefenseTowerEntity.this.showRange && (options = DefenseTowerEntity.this.range.getDrawOptions(new Color(255, 255, 255, 120), new Color(255, 255, 255, 50), DefenseTowerEntity.this.tileX, DefenseTowerEntity.this.tileY, gameCamera)) != null) {
                    list.add(new SortedDrawable(){

                        public int getPriority() {
                            return -1000000;
                        }

                        public void draw(TickManager tickManager) {
                            options.draw();
                        }
                    });
                }
            }
        };
        this.getLevel().hudManager.addElement(this.rangeElement);
    }

    public void serverTick() {
        super.serverTick();
        if (this.getLevel().isServer() && !this.onCooldown()) {
            GameAreaStream mobs = this.getLevel().entityManager.mobs.streamArea(this.getPosX(), this.getPosY(), this.searchDistance).filter(target -> target.isHostile).filter(target -> target.getDistance(this.getPosX(), this.getPosY()) <= (float)this.searchDistance);
            if (!this.targetBoss) {
                mobs = mobs.filter(target -> !target.isBoss());
            }
            mobs.findFirst().ifPresent(this::attackMob);
            this.startCooldown();
        }
    }

    public void onMouseHover(PlayerMob perspective, boolean debug) {
        super.onMouseHover(perspective, debug);
        String attackType = this.type.split("_")[1];
        float attackSpeed = 1000.0f / (float)this.cooldown;
        StringTooltips tooltips = new StringTooltips(this.getObject().getDisplayName());
        if (this.targetBoss) {
            tooltips.add(Localization.translate((String)"itemtooltip", (String)"defensetowertargetboss"));
        }
        if (this.gameWindow.isKeyDown(Control.getControl((String)"invquickmove").getKey())) {
            this.showRange = true;
            tooltips.add(Localization.translate((String)"defensetower", (String)"attackstats", (String)"damage", (Object)Float.valueOf(this.damage)));
            tooltips.add(Localization.translate((String)"defensetower", (String)"attacktype", (String)"type", (String)attackType));
            tooltips.add(Localization.translate((String)"defensetower", (String)"attackspeed", (String)"speed", (String)String.format("%.2f", Float.valueOf(attackSpeed))));
            tooltips.add(Localization.translate((String)"defensetower", (String)"rangestats", (String)"range", (Object)(this.attackDistance / 32 - 2)));
        } else {
            this.showRange = false;
            tooltips.add(Localization.translate((String)"defensetower", (String)"pressshift"));
        }
        GameTooltipManager.addTooltip((GameTooltips)tooltips, (TooltipLocation)TooltipLocation.INTERACT_FOCUS);
    }

    public void dispose() {
        super.dispose();
        if (this.rangeElement != null) {
            this.rangeElement.remove();
        }
        if (this.attacker != null) {
            this.attacker.remove();
        }
    }

    private boolean onCooldown() {
        return this.cooldownTime > this.getWorldEntity().getTime();
    }

    private void startCooldown() {
        this.cooldownTime = this.getWorldEntity().getTime() + this.cooldown;
    }

    private void attackMob(Mob target) {
        if (target.isVisible() && !target.removed() && this.isSamePlace(target)) {
            GameDamage damage = new GameDamage(this.damage);
            Projectile projectile = this.projectileStringID.contains("cannonball") ? ProjectileRegistry.getProjectile((String)this.projectileStringID, (Level)this.getLevel(), (float)this.getPosX(), (float)this.getPosY(), (float)target.x, (float)target.y, (float)200.0f, (int)(this.attackDistance + 96), (GameDamage)damage, (int)50, null) : ProjectileRegistry.getProjectile((String)this.projectileStringID, (Level)this.getLevel(), (float)this.getPosX(), (float)this.getPosY(), (float)target.x, (float)target.y, (float)200.0f, (int)(this.attackDistance + 96), (GameDamage)damage, null);
            projectile.setTargetPrediction(target, -10.0f);
            projectile.moveDist(10.0);
            this.getLevel().entityManager.projectiles.add((Entity)projectile);
        }
    }

    private float getPosX() {
        return this.tileX * 32 + 32;
    }

    private float getPosY() {
        return this.tileY * 32 - 16;
    }

    private boolean isSamePlace(Mob target) {
        return this.getLevel() != null && target.getLevel() != null && this.getLevel().isSamePlace(target.getLevel());
    }

    public GameMessage getAttackerName() {
        return new LocalMessage("defensetower", "attackername");
    }

    public DeathMessageTable getDeathMessages() {
        return this.getDeathMessages("explosion", 3);
    }

    public Mob getFirstAttackOwner() {
        return this.attacker;
    }
}

