/*
 * Decompiled with CFR 0.152.
 */
package DefenseTower.gameObject;

import DefenseTower.gameObject.DefenseTowerExtraObject;
import DefenseTower.gameObject.DefenseTowerObject2;
import DefenseTower.objectEntity.DefenseTowerEntity;
import java.awt.Rectangle;
import java.util.List;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.input.Control;
import necesse.engine.localization.Localization;
import necesse.engine.registries.ObjectRegistry;
import necesse.engine.window.GameWindow;
import necesse.engine.window.WindowManager;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.objectEntity.ObjectEntity;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.texture.TextureDrawOptions;
import necesse.gfx.drawOptions.texture.TextureDrawOptionsEnd;
import necesse.gfx.drawables.LevelSortedDrawable;
import necesse.gfx.drawables.OrderableDrawables;
import necesse.gfx.gameTexture.GameTexture;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.inventory.InventoryItem;
import necesse.level.gameObject.GameObject;
import necesse.level.maps.Level;
import necesse.level.maps.light.GameLight;
import necesse.level.maps.multiTile.MultiTile;
import necesse.level.maps.multiTile.StaticMultiTile;

public class DefenseTowerObject
extends DefenseTowerExtraObject {
    private final GameWindow gameWindow = WindowManager.getWindow();
    private final String towerType;
    private final float damage;
    private final long cooldown;
    private final boolean targetBoss;
    protected int counterIDRight;
    private PlayerMob owner;

    public DefenseTowerObject(String towerType, float damage, long cooldown, boolean targetBoss) {
        this.towerType = towerType;
        this.damage = damage;
        this.cooldown = cooldown;
        this.owner = null;
        this.targetBoss = targetBoss;
    }

    public static void registerDefenseTower() {
        DefenseTowerObject stoneTower1 = new DefenseTowerObject("stone", 28.0f, 700L, false);
        DefenseTowerObject2 stoneTower2 = new DefenseTowerObject2();
        DefenseTowerObject fireTower1 = new DefenseTowerObject("fire", 40.0f, 1000L, false);
        DefenseTowerObject2 fireTower2 = new DefenseTowerObject2();
        DefenseTowerObject poisonTower1 = new DefenseTowerObject("poison", 40.0f, 1000L, false);
        DefenseTowerObject2 poisonTower2 = new DefenseTowerObject2();
        DefenseTowerObject cannonballTower1 = new DefenseTowerObject("cannonball", 80.0f, 2000L, false);
        DefenseTowerObject2 cannonballTower2 = new DefenseTowerObject2();
        DefenseTowerObject boss_stoneTower1 = new DefenseTowerObject("stone_boss", 70.0f, 700L, true);
        DefenseTowerObject2 boss_stoneTower2 = new DefenseTowerObject2();
        DefenseTowerObject boss_fireTower1 = new DefenseTowerObject("fire_boss", 100.0f, 1000L, true);
        DefenseTowerObject2 boss_fireTower2 = new DefenseTowerObject2();
        DefenseTowerObject boss_poisonTower1 = new DefenseTowerObject("poison_boss", 100.0f, 1000L, true);
        DefenseTowerObject2 boss_poisonTower2 = new DefenseTowerObject2();
        int stoneID1 = ObjectRegistry.registerObject((String)"defensetowerstone", (GameObject)stoneTower1, (float)100.0f, (boolean)true);
        int stoneID2 = ObjectRegistry.registerObject((String)"defensetowerstone2", (GameObject)stoneTower2, (float)100.0f, (boolean)false);
        int fireID1 = ObjectRegistry.registerObject((String)"defensetowerfire", (GameObject)fireTower1, (float)100.0f, (boolean)true);
        int fireID2 = ObjectRegistry.registerObject((String)"defensetowerfire2", (GameObject)fireTower2, (float)100.0f, (boolean)false);
        int poisonID1 = ObjectRegistry.registerObject((String)"defensetowerpoison", (GameObject)poisonTower1, (float)100.0f, (boolean)true);
        int poisonID2 = ObjectRegistry.registerObject((String)"defensetowerpoison2", (GameObject)poisonTower2, (float)100.0f, (boolean)false);
        int cannonballID1 = ObjectRegistry.registerObject((String)"defensetowercannonball", (GameObject)cannonballTower1, (float)100.0f, (boolean)true);
        int cannonballID2 = ObjectRegistry.registerObject((String)"defensetowercannonball2", (GameObject)cannonballTower2, (float)100.0f, (boolean)false);
        int boss_stoneID1 = ObjectRegistry.registerObject((String)"defensetowerstone_boss", (GameObject)boss_stoneTower1, (float)200.0f, (boolean)true);
        int boss_stoneID2 = ObjectRegistry.registerObject((String)"defensetowerstone2_boss", (GameObject)boss_stoneTower2, (float)200.0f, (boolean)false);
        int boss_fireID1 = ObjectRegistry.registerObject((String)"defensetowerfire_boss", (GameObject)boss_fireTower1, (float)200.0f, (boolean)true);
        int boss_fireID2 = ObjectRegistry.registerObject((String)"defensetowerfire2_boss", (GameObject)boss_fireTower2, (float)200.0f, (boolean)false);
        int boss_poisonID1 = ObjectRegistry.registerObject((String)"defensetowerpoison_boss", (GameObject)boss_poisonTower1, (float)200.0f, (boolean)true);
        int boss_poisonID2 = ObjectRegistry.registerObject((String)"defensetowerpoison2_boss", (GameObject)boss_poisonTower2, (float)200.0f, (boolean)false);
        stoneTower1.setCounterIDs(stoneID1, stoneID2);
        stoneTower2.setCounterIDs(stoneID1, stoneID2);
        fireTower1.setCounterIDs(fireID1, fireID2);
        fireTower2.setCounterIDs(fireID1, fireID2);
        poisonTower1.setCounterIDs(poisonID1, poisonID2);
        poisonTower2.setCounterIDs(poisonID1, poisonID2);
        cannonballTower1.setCounterIDs(cannonballID1, cannonballID2);
        cannonballTower2.setCounterIDs(cannonballID1, cannonballID2);
        boss_stoneTower1.setCounterIDs(boss_stoneID1, boss_stoneID2);
        boss_stoneTower2.setCounterIDs(boss_stoneID1, boss_stoneID2);
        boss_fireTower1.setCounterIDs(boss_fireID1, boss_fireID2);
        boss_fireTower2.setCounterIDs(boss_fireID1, boss_fireID2);
        boss_poisonTower1.setCounterIDs(boss_poisonID1, boss_poisonID2);
        boss_poisonTower2.setCounterIDs(boss_poisonID1, boss_poisonID2);
    }

    public void loadTextures() {
        super.loadTextures();
        this.texture = GameTexture.fromFile((String)("objects/defensetower_" + this.towerType));
    }

    @Override
    protected void setCounterIDs(int var1, int var2) {
        this.counterIDRight = var2;
    }

    @Override
    public ObjectEntity getNewObjectEntity(Level level, int x, int y) {
        String projectileStringID = "dtprojectile_" + this.towerType;
        if (!projectileStringID.contains("cannonball")) {
            projectileStringID = this.targetBoss ? projectileStringID : projectileStringID + "piercing";
        }
        return new DefenseTowerEntity(level, "defensetowerentity_" + this.towerType, x, y, projectileStringID, 512, this.damage, this.cooldown, this.owner, this.targetBoss);
    }

    protected Rectangle getCollision(Level level, int x, int y, int rotation) {
        return new Rectangle(x * 32 + 6, y * 32, 22, 32);
    }

    @Override
    public ListGameTooltips getItemTooltips(InventoryItem item, PlayerMob perspective) {
        float attackSpeed = 1000.0f / (float)this.cooldown;
        ListGameTooltips tooltips = super.getItemTooltips(item, perspective);
        if (this.targetBoss) {
            tooltips.add(Localization.translate((String)"itemtooltip", (String)"defensetowertargetboss"));
        }
        if (this.gameWindow.isKeyDown(Control.getControl((String)"invquickmove").getKey())) {
            tooltips.add(Localization.translate((String)"defensetower", (String)"attackstats", (String)"damage", (Object)Float.valueOf(this.damage)));
            tooltips.add(Localization.translate((String)"defensetower", (String)"attacktype", (String)"type", (String)this.towerType));
            tooltips.add(Localization.translate((String)"defensetower", (String)"attackspeed", (String)"speed", (String)String.format("%.2f", Float.valueOf(attackSpeed))));
            tooltips.add(Localization.translate((String)"defensetower", (String)"rangestats", (String)"range", (Object)14));
        } else {
            tooltips.add(Localization.translate((String)"defensetower", (String)"pressshift"));
        }
        return tooltips;
    }

    public MultiTile getMultiTile(int rotation) {
        return new StaticMultiTile(0, 0, 2, 1, 0, true, new int[]{this.getID(), this.counterIDRight});
    }

    public void addDrawables(List<LevelSortedDrawable> list, OrderableDrawables tileList, Level level, int tileX, int tileY, TickManager tickManager, GameCamera camera, PlayerMob perspective) {
        GameLight light = level.getLightLevel(tileX, tileY);
        int drawX = camera.getTileDrawX(tileX);
        int drawY = camera.getTileDrawY(tileY);
        boolean active = this.isActive(level, tileX, tileY);
        TextureDrawOptionsEnd options = this.texture.initDraw().sprite(active ? 0 : 1, 0, 64, this.texture.getHeight()).light(light).pos(drawX, drawY - this.texture.getHeight() + 32);
        list.add(new LevelSortedDrawable(this, tileX, tileY, (TextureDrawOptions)options){
            final /* synthetic */ TextureDrawOptions val$options;
            {
                this.val$options = textureDrawOptions;
                super(arg0, arg1, arg2);
            }

            public int getSortY() {
                return 16;
            }

            public void draw(TickManager tickManager) {
                this.val$options.draw();
            }
        });
    }

    public void drawPreview(Level level, int tileX, int tileY, int rotation, float alpha, PlayerMob player, GameCamera camera) {
        if (this.owner == null) {
            this.owner = player;
        }
        int drawX = camera.getTileDrawX(tileX);
        int drawY = camera.getTileDrawY(tileY);
        this.texture.initDraw().sprite(0, 0, 64, this.texture.getHeight()).alpha(alpha).draw(drawX, drawY - this.texture.getHeight() + 32);
    }

    public GameTexture generateItemTexture() {
        return GameTexture.fromFile((String)("items/defensetower_" + this.towerType));
    }
}

