/*
 * Decompiled with CFR 0.152.
 */
package DefenseTower.gameObject;

import java.awt.Color;
import java.awt.Rectangle;
import java.util.List;
import necesse.engine.localization.Localization;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.objectEntity.ObjectEntity;
import necesse.gfx.gameTexture.GameTexture;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.toolItem.ToolType;
import necesse.level.gameObject.GameObject;
import necesse.level.gameObject.ObjectHoverHitbox;
import necesse.level.maps.Level;

public abstract class DefenseTowerExtraObject
extends GameObject {
    protected GameTexture texture;

    public DefenseTowerExtraObject() {
        super(new Rectangle(32, 32));
        this.mapColor = new Color(107, 107, 107);
        this.displayMapTooltip = true;
        this.toolType = ToolType.PICKAXE;
        this.objectHealth = 100;
        this.stackSize = 10;
        this.drawDamage = false;
        this.isLightTransparent = true;
        this.lightLevel = 200;
        this.lightSat = 0.2f;
        this.lightHue = 60.0f;
        this.roomProperties.add("light");
    }

    protected abstract void setCounterIDs(int var1, int var2);

    public abstract ObjectEntity getNewObjectEntity(Level var1, int var2, int var3);

    public List<ObjectHoverHitbox> getHoverHitboxes(Level level, int layerID, int tileX, int tileY) {
        List list = super.getHoverHitboxes(level, layerID, tileX, tileY);
        list.add(new ObjectHoverHitbox(layerID, tileX, tileY, 0, -32, 32, 32));
        return list;
    }

    public boolean canInteract(Level level, int x, int y, PlayerMob player) {
        return false;
    }

    public ListGameTooltips getItemTooltips(InventoryItem item, PlayerMob perspective) {
        ListGameTooltips tooltips = super.getItemTooltips(item, perspective);
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"defensetowertip"));
        return tooltips;
    }

    public int getLightLevel(Level level, int layerID, int tileX, int tileY) {
        return this.isActive(level, tileX, tileY) ? 0 : this.lightLevel;
    }

    public void onWireUpdate(Level level, int layerID, int tileX, int tileY, int wireID, boolean active) {
        Rectangle rect = this.getMultiTile(0).getTileRectangle(tileX, tileY);
        level.lightManager.updateStaticLight(rect.x, rect.y, rect.x + rect.width - 1, rect.y + rect.height - 1, true);
    }

    protected boolean isActive(Level level, int x, int y) {
        return this.getMultiTile(0).streamIDs(x, y).noneMatch(c -> level.wireManager.isWireActiveAny(c.tileX, c.tileY));
    }
}

